/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import rs.baselib.crypto.DecryptionException;
import rs.baselib.licensing.DefaultLicense;
import rs.baselib.licensing.ILicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.ILicenseCreator;
import rs.baselib.licensing.ILicensingScheme;
import rs.baselib.licensing.LicenseException;
import rs.baselib.licensing.LicensingScheme;

public class LicenseGenerator {
    private ILicenseCreator licenseCreator;

    public LicenseGenerator() throws DecryptionException {
        this((ILicensingScheme)null);
    }

    public LicenseGenerator(ILicensingScheme scheme) throws DecryptionException {
        this(scheme != null ? scheme.getLicenseCreator() : LicensingScheme.RSA_LICENSE.getLicenseCreator());
    }

    public LicenseGenerator(ILicenseCreator licenseCreator) throws DecryptionException {
        this.licenseCreator = licenseCreator;
    }

    public ILicenseCreator getLicenseCreator() {
        return this.licenseCreator;
    }

    public String createLicenseKey(ILicenseContext context) {
        return this.createLicenseKey(DefaultLicense.class, context);
    }

    public String createLicenseKey(Class<? extends ILicense> licenseClass, ILicenseContext context) {
        try {
            ILicense license = licenseClass.newInstance();
            license.init(context);
            return this.createLicenseKey(context, license);
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LicenseException("Cannot create license", t);
        }
    }

    public String createLicenseKey(ILicenseContext context, ILicense license) {
        try {
            return this.getLicenseCreator().createLicenseKey(context, license);
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LicenseException("Cannot create license key", t);
        }
    }
}

