/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import rs.baselib.licensing.ILicenseCreator;
import rs.baselib.licensing.ILicenseVerifier;
import rs.baselib.licensing.ILicensingScheme;
import rs.baselib.licensing.LicenseException;
import rs.baselib.licensing.internal.OctetLicenseCreator;
import rs.baselib.licensing.internal.OctetLicenseVerifier;
import rs.baselib.licensing.internal.RsaLicenseCreator;
import rs.baselib.licensing.internal.RsaLicenseVerifier;

public enum LicensingScheme implements ILicensingScheme
{
    OCTET_LICENSE(OctetLicenseCreator.class, OctetLicenseVerifier.class),
    RSA_LICENSE(RsaLicenseCreator.class, RsaLicenseVerifier.class);

    private Class<? extends ILicenseCreator> creatorClass;
    private Class<? extends ILicenseVerifier> verifierClass;
    private ILicenseCreator creator;
    private ILicenseVerifier verifier;

    private LicensingScheme(Class<? extends ILicenseCreator> creatorClass, Class<? extends ILicenseVerifier> verifierClass) {
        this.creatorClass = creatorClass;
        this.verifierClass = verifierClass;
    }

    @Override
    public ILicenseCreator getLicenseCreator() {
        if (this.creator == null) {
            this.creator = this.create(this.creatorClass);
        }
        return this.creator;
    }

    @Override
    public ILicenseVerifier getLicenseVerifier() {
        if (this.verifier == null) {
            this.verifier = this.create(this.verifierClass);
        }
        return this.verifier;
    }

    protected <T> T create(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw new LicenseException("Cannot create instance of " + clazz.getName(), t);
        }
    }
}

