/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing.internal;

import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import org.apache.commons.codec.binary.Base32;
import rs.baselib.crypto.DataSigner;
import rs.baselib.crypto.DecryptionException;
import rs.baselib.crypto.SigningException;
import rs.baselib.io.ConverterUtils;
import rs.baselib.licensing.DefaultLicenseContext;
import rs.baselib.licensing.ILicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.ILicenseVerifier;
import rs.baselib.licensing.LicenseException;
import rs.baselib.licensing.SimpleLicense;

public class OctetLicenseVerifier
implements ILicenseVerifier {
    private Base32 decoder = new Base32(true);

    @Override
    public ILicense verify(String licenseKey, ILicenseContext context) {
        try {
            byte[] bytes = this.decoder.decode(OctetLicenseVerifier.ungroup(licenseKey));
            for (int i = 0; i < 4; ++i) {
                bytes[i] = (byte)(bytes[i] ^ bytes[4 + i]);
            }
            byte[] b = new byte[4];
            System.arraycopy(bytes, 0, b, 0, 4);
            long expirationTime = (long)ConverterUtils.toInt(b) * 1000L;
            byte[] signature = new byte[bytes.length - 4];
            System.arraycopy(bytes, 4, signature, 0, signature.length);
            DefaultLicenseContext createContext = new DefaultLicenseContext();
            createContext.set("product", context.get("product"));
            createContext.set("owner", context.get("owner"));
            createContext.set("expirationDate", (Object)expirationTime);
            SimpleLicense license = new SimpleLicense();
            license.init(createContext);
            if (!this.verify(signature, license, context)) {
                throw new LicenseException("Invalid license: " + licenseKey);
            }
            license.verify(context);
            return license;
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new LicenseException("Invalid license: " + licenseKey, t);
        }
    }

    protected boolean verify(byte[] signature, SimpleLicense license, ILicenseContext context) throws DecryptionException, SigningException, UnsupportedEncodingException {
        DataSigner signer = context.get(DataSigner.class);
        if (signer == null) {
            signer = new DataSigner(context.get(PublicKey.class));
            context.set(DataSigner.class, signer);
        }
        return signer.verify(signature, SimpleLicense.serialize(license));
    }

    protected static String ungroup(String s) {
        return s.replaceAll("\\-", "");
    }
}

