/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.security;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import rs.baselib.configuration.IConfigurable;
import rs.baselib.security.IPasswordCallback;

public class DefaultPasswordCallback
implements IPasswordCallback,
IConfigurable {
    private char[] password;

    @Override
    public void configure(Configuration cfg) throws ConfigurationException {
        String s;
        if (cfg != null && (s = cfg.getString("password(0)")) != null) {
            this.password = s.toCharArray();
        }
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public byte[] getSalt() {
        try {
            byte[] b = new String(this.getPassword()).getBytes("UTF-8");
            while (b.length < 8) {
                b = ArrayUtils.addAll((byte[])b, (byte[])b);
            }
            if (b.length > 8) {
                b = ArrayUtils.subarray((byte[])b, (int)0, (int)8);
            }
            return b;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create salt from passphrase", e);
        }
    }
}

