/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.security;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import rs.baselib.configuration.IConfigurable;
import rs.baselib.security.AbstractAuthorizationCallback;

public class GuiAuthorizationCallback
extends AbstractAuthorizationCallback
implements IConfigurable {
    public static final String DEFAULT_LOGIN_LABEL = "Login:";
    public static final String DEFAULT_PASSWORD_LABEL = "Password:";
    public static final String DEFAULT_PROMPT = "Please enter your Bugzilla login data!";
    public static final String DEFAULT_TITLE = "Bugzilla Login";
    private String loginLabel;
    private String passwordLabel;
    private String prompt;
    private String title;
    private boolean dlgClosedOption;
    private JDialog dlg;
    private JTextField loginField;
    private JButton okButton;
    private JButton cancelButton;

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        this.setName(config.getString("login"));
        this.setLoginLabel(config.getString("login-label"));
        this.setPasswordLabel(config.getString("password-label"));
        this.setPrompt(config.getString("prompt"));
        this.setTitle(config.getString("title"));
    }

    public String getLoginLabel() {
        return this.loginLabel;
    }

    public void setLoginLabel(String loginLabel) {
        if (loginLabel == null) {
            loginLabel = DEFAULT_LOGIN_LABEL;
        }
        this.loginLabel = loginLabel;
    }

    public String getPasswordLabel() {
        return this.passwordLabel;
    }

    public void setPasswordLabel(String passwordLabel) {
        if (passwordLabel == null) {
            passwordLabel = DEFAULT_PASSWORD_LABEL;
        }
        this.passwordLabel = passwordLabel;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        if (prompt == null) {
            prompt = DEFAULT_PROMPT;
        }
        this.prompt = prompt;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = DEFAULT_TITLE;
        }
        this.title = title;
    }

    @Override
    public String getName() {
        if (super.getPassword() == null) {
            this.showPopup();
        }
        return super.getName();
    }

    @Override
    public String getPassword() {
        if (super.getPassword() == null) {
            this.showPopup();
        }
        return super.getPassword();
    }

    protected void showPopup() {
        this.loginField = new JTextField(super.getName());
        JPasswordField passwordField = new JPasswordField();
        JLabel generalPrompt = new JLabel(this.getPrompt());
        JLabel loginLabel = new JLabel(this.getLoginLabel());
        JLabel passwordLabel = new JLabel(this.getPasswordLabel());
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        gb.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)generalPrompt, gb);
        gb = new GridBagConstraints();
        gb.insets = new Insets(10, 10, 10, 10);
        gb.anchor = 17;
        panel.add((Component)loginLabel, gb);
        gb = new GridBagConstraints();
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)this.loginField, gb);
        gb = new GridBagConstraints();
        gb.anchor = 17;
        gb.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)passwordLabel, gb);
        gb = new GridBagConstraints();
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)passwordField, gb);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        gb = new GridBagConstraints();
        gb.anchor = 13;
        gb.insets = new Insets(10, 10, 10, 10);
        buttonPanel.add((Component)this.okButton, gb);
        gb = new GridBagConstraints();
        gb.anchor = 17;
        gb.insets = new Insets(10, 10, 10, 10);
        buttonPanel.add((Component)this.cancelButton, gb);
        gb = new GridBagConstraints();
        gb.gridwidth = 0;
        gb.gridheight = 0;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.fill = 1;
        gb.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)buttonPanel, gb);
        this.dlg = new JDialog((Frame)null, this.getTitle(), true);
        this.dlg.setDefaultCloseOperation(2);
        this.dlg.getContentPane().add((Component)panel, "Center");
        this.dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GuiAuthorizationCallback.this.dlgClosedOption = false;
                GuiAuthorizationCallback.this.dlg.dispose();
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                GuiAuthorizationCallback.this.loginField.requestFocus();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiAuthorizationCallback.this.dlgClosedOption = true;
                GuiAuthorizationCallback.this.dlg.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GuiAuthorizationCallback.this.dlgClosedOption = false;
                GuiAuthorizationCallback.this.dlg.dispose();
            }
        });
        this.dlg.getRootPane().setDefaultButton(this.okButton);
        this.dlgClosedOption = false;
        this.dlg.pack();
        this.dlg.setVisible(true);
        if (!this.dlgClosedOption) {
            throw new IllegalStateException("User aborted action");
        }
        this.setName(this.loginField.getText());
        this.setPassword(new String(passwordField.getPassword()));
    }
}

