/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.util.Comparator;
import rs.baselib.util.BeanValueProvider;
import rs.baselib.util.DefaultComparator;
import rs.baselib.util.IValueProvider;

public class BeanComparator<T>
implements Comparator<T> {
    private Comparator<Object> comparator;
    private IValueProvider[] valueProviders;

    public BeanComparator(String ... beanProperties) {
        this((Comparator<Object>)null, (IValueProvider[])BeanValueProvider.getValueProviders(beanProperties));
    }

    public BeanComparator(Comparator<Object> comparator, String ... beanProperties) {
        this(comparator, (IValueProvider[])BeanValueProvider.getValueProviders(beanProperties));
    }

    public BeanComparator(IValueProvider ... valueProviders) {
        this((Comparator<Object>)null, valueProviders);
    }

    public BeanComparator(Comparator<Object> comparator, IValueProvider ... valueProviders) {
        this.comparator = comparator;
        this.valueProviders = valueProviders;
    }

    public Comparator<Object> getComparator() {
        return this.comparator != null ? this.comparator : DefaultComparator.INSTANCE;
    }

    public IValueProvider[] getValueProviders() {
        return this.valueProviders;
    }

    @Override
    public int compare(T o1, T o2) {
        for (IValueProvider provider : this.getValueProviders()) {
            int cmp;
            Object v1 = o1;
            Object v2 = o2;
            if (provider != null) {
                v1 = provider.getValue(o1);
                v2 = provider.getValue(o2);
            }
            if ((cmp = this.getComparator().compare(v1, v2)) == 0) continue;
            return cmp;
        }
        return 0;
    }
}

