/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.io.Serializable;
import rs.baselib.util.RsDate;

public class DateTimePeriod
implements Serializable {
    private static final long serialVersionUID = 7921353873601015818L;
    private RsDate from;
    private RsDate until;

    public DateTimePeriod() {
        this(null, null);
    }

    public DateTimePeriod(RsDate from, long duration) {
        this(from, new RsDate(from.getTimeInMillis() + duration));
    }

    public DateTimePeriod(RsDate from, RsDate until) {
        this.setFrom(from);
        this.setUntil(until);
    }

    public RsDate getFrom() {
        return this.from;
    }

    public void setFrom(RsDate from) {
        this.from = from;
    }

    public RsDate getUntil() {
        return this.until;
    }

    public void setUntil(RsDate until) {
        this.until = until;
    }

    public long getDuration() {
        RsDate from = this.getFrom();
        RsDate until = this.getUntil();
        if (from == null || until == null) {
            return -1L;
        }
        return until.getTimeInMillis() - from.getTimeInMillis();
    }

    public boolean isIn(RsDate date) {
        RsDate from = this.getFrom();
        RsDate until = this.getUntil();
        if (from == null && until == null) {
            return true;
        }
        if (until == null) {
            return from.before(date);
        }
        if (from == null) {
            return until.after(date);
        }
        return from.before(date) && until.after(date);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.until == null ? 0 : this.until.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimePeriod)) {
            return false;
        }
        DateTimePeriod other = (DateTimePeriod)obj;
        if (this.getFrom() == null ? other.getFrom() != null : !this.getFrom().equals(other.getFrom())) {
            return false;
        }
        return !(this.getUntil() == null ? other.getUntil() != null : !this.getUntil().equals(other.getUntil()));
    }

    public DateTimePeriod deepCopy() {
        RsDate until;
        RsDate from = this.getFrom();
        if (from != null) {
            from = (RsDate)from.clone();
        }
        if ((until = this.getUntil()) != null) {
            until = (RsDate)until.clone();
        }
        return new DateTimePeriod(from, until);
    }
}

