/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import rs.baselib.util.CommonUtils;
import rs.baselib.util.ICache;

public class WeakMapCache<K, V>
implements ICache<K, V> {
    private static int DEFAULT_CLEAR_COUNT = 10;
    private Map<K, WeakReference<V>> cache = new HashMap<K, WeakReference<V>>();
    private ReferenceQueue<V> referenceQueue = new ReferenceQueue();
    private int clearCounter = DEFAULT_CLEAR_COUNT;

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, WeakReference<V>> entry : this.cache.entrySet()) {
            if (!CommonUtils.equals(entry.getValue().get(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        WeakReference<V> ref;
        if (this.clearCounter-- <= 0) {
            this.clearMap();
        }
        return (ref = this.cache.get(key)) != null ? (V)ref.get() : null;
    }

    protected void clearMap() {
        Reference<V> rf = this.referenceQueue.poll();
        while (rf != null) {
            this.cache.remove(rf);
            rf = this.referenceQueue.poll();
        }
        this.clearCounter = DEFAULT_CLEAR_COUNT;
    }

    @Override
    public V put(K key, V value) {
        WeakReference<V> ref = this.cache.put(key, new WeakReference<V>(value));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V remove(Object key) {
        WeakReference<V> ref = this.cache.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList rc = new ArrayList();
        for (Map.Entry<K, WeakReference<V>> entry : this.cache.entrySet()) {
            rc.add(entry.getValue().get());
        }
        return rc;
    }
}

