/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.client;

import com.sportdataapi.data.League;
import com.sportdataapi.util.AbstractClient;
import com.sportdataapi.util.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class LeaguesClient
extends AbstractClient {
    public LeaguesClient(WebTarget target) {
        super(target.path("leagues"));
    }

    public List<League> list() {
        return this.list(false);
    }

    public List<League> list(boolean subscribedOnly) {
        WebTarget target = this.getTarget();
        if (subscribedOnly) {
            target = target.queryParam("subscribed", new Object[]{subscribedOnly});
        }
        Response response = (Response)this.registerRequest(target).request().get((GenericType)new GenericType<Response<List<League>>>(){});
        return (List)response.getData();
    }

    public List<League> list(int countryId) {
        if (countryId <= 0) {
            throw new RuntimeException("countryId must be a positive number");
        }
        WebTarget target = this.getTarget().queryParam("country_id", new Object[]{countryId});
        Response response = (Response)this.registerRequest(target).request().get((GenericType)new GenericType<Response<Map<String, League>>>(){});
        return new ArrayList<League>(((Map)response.getData()).values());
    }

    public League get(int id) {
        try {
            Response response = (Response)this.registerRequest(this.getTarget().path("" + id)).request().get((GenericType)new GenericType<Response<League>>(){});
            return (League)response.getData();
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

