/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.client;

import com.sportdataapi.data.Match;
import com.sportdataapi.data.MatchStatus;
import com.sportdataapi.util.AbstractClient;
import com.sportdataapi.util.Response;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import rs.baselib.util.RsDay;

public class MatchesClient
extends AbstractClient {
    private static SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("");

    public MatchesClient(WebTarget target) {
        super(target.path("matches"));
    }

    public List<Match> list(int seasonId) {
        return this.list(seasonId, null, null, null);
    }

    public List<Match> list(int seasonId, MatchStatus status) {
        return this.list(seasonId, status, null, null);
    }

    public List<Match> list(int seasonId, RsDay from, RsDay to) {
        return this.list(seasonId, null, from, to);
    }

    public List<Match> list(int seasonId, MatchStatus status, RsDay from, RsDay to) {
        WebTarget target = this.getTarget().queryParam("season_id", new Object[]{seasonId});
        if (status != null) {
            target = target.queryParam("status_id", new Object[]{status.getId()});
        }
        if (from != null) {
            target = target.queryParam("date_from", new Object[]{DATE_FORMATTER.format(from.getTime())});
        }
        if (to != null) {
            target = target.queryParam("date_to", new Object[]{DATE_FORMATTER.format(from.getTime())});
        }
        Response response = (Response)this.registerRequest(target).request().get((GenericType)new GenericType<Response<List<Match>>>(){});
        return (List)response.getData();
    }

    public List<Match> listLive() {
        return this.listLive(0, null);
    }

    public List<Match> listLive(int seasonId) {
        return this.listLive(seasonId, null);
    }

    public List<Match> listLive(int seasonId, MatchStatus status) {
        WebTarget target = this.getTarget().queryParam("live", new Object[]{"true"});
        if (seasonId > 0) {
            target = target.queryParam("season_id", new Object[]{seasonId});
        }
        if (status != null) {
            target = target.queryParam("status_id", new Object[]{status.getId()});
        }
        Response response = (Response)this.registerRequest(target).request().get((GenericType)new GenericType<Response<List<Match>>>(){});
        return (List)response.getData();
    }

    public Match get(int id) {
        try {
            Response response = (Response)this.registerRequest(this.getTarget().path("" + id)).request().get((GenericType)new GenericType<Response<Match>>(){});
            return (Match)response.getData();
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

