/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.client;

import com.sportdataapi.data.Player;
import com.sportdataapi.util.AbstractClient;
import com.sportdataapi.util.Response;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class PlayersClient
extends AbstractClient {
    public PlayersClient(WebTarget target) {
        super(target.path("players"));
    }

    public List<Player> list(int countryId) {
        return this.list(countryId, 0, 0);
    }

    public List<Player> listMinAge(int countryId, int minAge) {
        return this.list(countryId, minAge, 0);
    }

    public List<Player> listMaxAge(int countryId, int maxAge) {
        return this.list(countryId, 0, maxAge);
    }

    public List<Player> list(int countryId, int minAge, int maxAge) {
        WebTarget target = this.getTarget().queryParam("country_id", new Object[]{"" + countryId});
        if (minAge > 0) {
            target = target.queryParam("min_age", new Object[]{"" + minAge});
        }
        if (maxAge > 0) {
            target = target.queryParam("max_age", new Object[]{"" + maxAge});
        }
        Response response = (Response)this.registerRequest(target).request().get((GenericType)new GenericType<Response<List<Player>>>(){});
        return (List)response.getData();
    }

    public Player get(int id) {
        try {
            Response response = (Response)this.registerRequest(this.getTarget().path("" + id)).request().get((GenericType)new GenericType<Response<Player>>(){});
            return (Player)response.getData();
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

