/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sportdataapi.data.TeamStandings;
import com.sportdataapi.util.StandingsDeserializer;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LeagueStandings {
    private int leagueId;
    private int seasonId;
    private boolean hasGroups;
    private List<TeamStandings> teamStandings;
    private Map<String, List<TeamStandings>> groupStandings;

    @JsonProperty(value="league_id")
    public int getLeagueId() {
        return this.leagueId;
    }

    @JsonProperty(value="league_id")
    public void setLeagueId(int leagueId) {
        this.leagueId = leagueId;
    }

    @JsonProperty(value="season_id")
    public int getSeasonId() {
        return this.seasonId;
    }

    @JsonProperty(value="season_id")
    public void setSeasonId(int seasonId) {
        this.seasonId = seasonId;
    }

    @JsonProperty(value="has_groups")
    public boolean isHasGroups() {
        return this.hasGroups;
    }

    @JsonProperty(value="has_groups")
    public void setHasGroups(boolean hasGroups) {
        this.hasGroups = hasGroups;
    }

    public List<TeamStandings> getTeamStandings() {
        return this.teamStandings;
    }

    public Map<String, List<TeamStandings>> getGroupStandings() {
        return this.groupStandings;
    }

    @JsonProperty(value="standings")
    @JsonDeserialize(using=StandingsDeserializer.class)
    public void setStandings(Object standings) {
        if (standings instanceof List) {
            this.teamStandings = (List)standings;
        } else if (standings instanceof Map) {
            this.groupStandings = (Map)standings;
        }
    }

    public String toString() {
        return "LeagueStandings [leagueId=" + this.leagueId + ", seasonId=" + this.seasonId + ", hasGroups=" + this.hasGroups + ", teamStandings=" + this.teamStandings + ", groupStandings=" + this.groupStandings + "]";
    }
}

