/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sportdataapi.data.Group;
import com.sportdataapi.data.MatchEvent;
import com.sportdataapi.data.MatchResults;
import com.sportdataapi.data.MatchStatus;
import com.sportdataapi.data.Round;
import com.sportdataapi.data.Stage;
import com.sportdataapi.data.Team;
import com.sportdataapi.data.TeamLineup;
import com.sportdataapi.data.TeamStats;
import com.sportdataapi.data.Venue;
import com.sportdataapi.util.RsDateDeserializer;
import java.util.List;
import rs.baselib.util.RsDate;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Match {
    private int id;
    private MatchStatus status;
    private String statusText;
    private RsDate start;
    private Integer minute;
    private int leagueId;
    private int seasonId;
    private int roundId;
    private Round round;
    private Stage stage;
    private Group group;
    private MatchResults results;
    private Team homeTeam;
    private Team guestTeam;
    private int refereeId;
    private List<MatchEvent> events;
    private TeamStats homeTeamStats;
    private TeamStats guestTeamStats;
    private TeamLineup homeTeamLineup;
    private TeamLineup guestTeamLineup;
    private Venue venue;

    @JsonProperty(value="match_id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="match_id")
    public void setId(int id) {
        this.id = id;
    }

    @JsonProperty(value="status_code")
    public MatchStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status_code")
    public void setStatus(MatchStatus status) {
        this.status = status;
    }

    @JsonProperty(value="status")
    public String getStatusText() {
        return this.statusText;
    }

    @JsonProperty(value="status")
    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    @JsonProperty(value="match_start")
    @JsonDeserialize(using=RsDateDeserializer.class)
    public RsDate getStart() {
        return this.start;
    }

    @JsonProperty(value="match_start")
    @JsonDeserialize(using=RsDateDeserializer.class)
    public void setStart(RsDate start) {
        this.start = start;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    @JsonProperty(value="league_id")
    public int getLeagueId() {
        return this.leagueId;
    }

    @JsonProperty(value="league_id")
    public void setLeagueId(int leagueId) {
        this.leagueId = leagueId;
    }

    @JsonProperty(value="season_id")
    public int getSeasonId() {
        return this.seasonId;
    }

    @JsonProperty(value="season_id")
    public void setSeasonId(int seasonId) {
        this.seasonId = seasonId;
    }

    @JsonProperty(value="round_id")
    public int getRoundId() {
        return this.roundId;
    }

    @JsonProperty(value="round_id")
    public void setRoundId(int roundId) {
        this.roundId = roundId;
    }

    public Round getRound() {
        return this.round;
    }

    public void setRound(Round round) {
        this.round = round;
        if (round != null) {
            this.setRoundId(round.getId());
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    @JsonProperty(value="stats")
    public MatchResults getResults() {
        return this.results;
    }

    @JsonProperty(value="stats")
    public void setResults(MatchResults results) {
        this.results = results;
    }

    @JsonProperty(value="home_team")
    public Team getHomeTeam() {
        return this.homeTeam;
    }

    @JsonProperty(value="home_team")
    public void setHomeTeam(Team homeTeam) {
        this.homeTeam = homeTeam;
    }

    @JsonProperty(value="away_team")
    public Team getGuestTeam() {
        return this.guestTeam;
    }

    @JsonProperty(value="away_team")
    public void setGuestTeam(Team guestTeam) {
        this.guestTeam = guestTeam;
    }

    @JsonProperty(value="referee_id")
    public int getRefereeId() {
        return this.refereeId;
    }

    @JsonProperty(value="referee_id")
    public void setRefereeId(int refereeId) {
        this.refereeId = refereeId;
    }

    @JsonProperty(value="match_events")
    public List<MatchEvent> getEvents() {
        return this.events;
    }

    @JsonProperty(value="match_events")
    public void setEvents(List<MatchEvent> events) {
        this.events = events;
    }

    @JsonProperty(value="match_statistics")
    public void setMatchStatistics(TeamStats[] stats) {
        if (stats != null) {
            for (TeamStats stat : stats) {
                if (this.homeTeam != null && this.homeTeam.getId() == stat.getTeamId()) {
                    this.homeTeamStats = stat;
                }
                if (this.guestTeam == null || this.guestTeam.getId() != stat.getTeamId()) continue;
                this.guestTeamStats = stat;
            }
        }
    }

    public TeamStats getHomeTeamStats() {
        return this.homeTeamStats;
    }

    public TeamStats getGuestTeamStats() {
        return this.guestTeamStats;
    }

    public void setLineups(TeamLineup[] lineups) {
        if (lineups != null) {
            for (TeamLineup lineup : lineups) {
                if (this.homeTeam != null && this.homeTeam.getId() == lineup.getTeamId()) {
                    this.homeTeamLineup = lineup;
                }
                if (this.guestTeam == null || this.guestTeam.getId() != lineup.getTeamId()) continue;
                this.guestTeamLineup = lineup;
            }
        }
    }

    public TeamLineup getHomeTeamLineup() {
        return this.homeTeamLineup;
    }

    public TeamLineup getGuestTeamLineup() {
        return this.guestTeamLineup;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    public String toString() {
        return "Match [id=" + this.id + ", status=" + this.status + ", statusText=" + this.statusText + ", start=" + this.start + ", minute=" + this.minute + ", leagueId=" + this.leagueId + ", seasonId=" + this.seasonId + ", roundId=" + this.roundId + ", results=" + this.results + ", homeTeam=" + this.homeTeam + ", guestTeam=" + this.guestTeam + ", events=" + this.events + ", homeTeamStats=" + this.homeTeamStats + ", guestTeamStats=" + this.guestTeamStats + ", homeTeamLineup=" + this.homeTeamLineup + ", guestTeamLineup=" + this.guestTeamLineup + ", venue=" + this.venue + "]";
    }
}

