/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.util;

import com.sportdataapi.client.RequestListener;
import com.sportdataapi.util.SubClientHolder;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;

public abstract class AbstractClient {
    private SubClientHolder subclients;
    private URI lastURI;
    private Set<RequestListener> requestListeners;

    protected AbstractClient(WebTarget target) {
        this.subclients = new SubClientHolder(target);
        this.lastURI = null;
        this.requestListeners = new HashSet<RequestListener>();
    }

    protected WebTarget registerRequest(WebTarget target) {
        if (target != null) {
            this.lastURI = target.getUri();
        }
        this.fireRequestRegistered(this.lastURI);
        return target;
    }

    public Invocation.Builder getRequest() {
        Invocation.Builder rc = this.registerRequest(this.getTarget()).request();
        return rc;
    }

    public URI getLastUri() {
        return this.lastURI;
    }

    protected WebTarget getTarget() {
        return this.subclients.getTarget();
    }

    public void addRequestListener(RequestListener listener) {
        this.requestListeners.add(listener);
    }

    protected void fireRequestRegistered(URI uri) {
        for (RequestListener r : this.requestListeners) {
            r.registerRequest(uri);
        }
    }

    public <T extends AbstractClient> T get(Class<T> clazz) {
        T rc = this.subclients.get(clazz);
        if (this instanceof RequestListener) {
            ((AbstractClient)rc).addRequestListener((RequestListener)((Object)this));
        }
        for (RequestListener r : this.requestListeners) {
            ((AbstractClient)rc).addRequestListener(r);
        }
        return rc;
    }
}

