/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sportdataapi.SdaClient;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.NewCookie;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static Logger log = LoggerFactory.getLogger(ClientFilter.class);
    private String apiKey;
    private Map<String, NewCookie> cookies;

    public ClientFilter(String apiKey) {
        if (apiKey == null) {
            throw new RuntimeException("No API key provided");
        }
        this.apiKey = apiKey;
        this.cookies = this.readCookies();
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        for (Map.Entry cookie : responseContext.getCookies().entrySet()) {
            String n = (String)cookie.getKey();
            NewCookie c = (NewCookie)cookie.getValue();
            this.cookies.put(n, c);
        }
        this.saveCookies();
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        requestContext.getHeaders().add((Object)"apiKey", (Object)this.apiKey);
        requestContext.getHeaders().add((Object)"User-Agent", (Object)(SdaClient.NAME + "/" + SdaClient.VERSION + " (" + SdaClient.URL + ")"));
        Date now = new Date();
        for (Map.Entry<String, NewCookie> entry : this.cookies.entrySet()) {
            String name = entry.getKey();
            NewCookie cookie = entry.getValue();
            if (cookie.getExpiry().before(now)) {
                this.cookies.remove(name);
                continue;
            }
            requestContext.getHeaders().add((Object)"Cookie", (Object)(cookie.getName() + "=" + cookie.getValue()));
        }
    }

    protected Map<String, NewCookie> readCookies() {
        HashMap<String, NewCookie> rc;
        block16: {
            rc = new HashMap<String, NewCookie>();
            ObjectMapper mapper = new ObjectMapper();
            File dbFile = new File(".", "cookies.db");
            if (dbFile.exists() && dbFile.canRead()) {
                try {
                    JsonNode arrayNode = mapper.readTree(dbFile);
                    if (arrayNode.isArray()) {
                        Iterator i = arrayNode.elements();
                        while (i.hasNext()) {
                            JsonNode node = (JsonNode)i.next();
                            if (node.isObject()) {
                                String name = null;
                                String value = null;
                                String path = null;
                                String domain = null;
                                int version = 1;
                                String comment = null;
                                int maxAge = 0;
                                Date expiry = null;
                                boolean secure = false;
                                boolean httpOnly = false;
                                JsonNode field = node.findValue("name");
                                if (field != null) {
                                    name = field.asText();
                                }
                                if ((field = node.findValue("value")) != null) {
                                    value = field.asText();
                                }
                                if ((field = node.findValue("path")) != null) {
                                    path = field.asText();
                                }
                                if ((field = node.findValue("domain")) != null) {
                                    domain = field.asText();
                                }
                                if ((field = node.findValue("version")) != null) {
                                    version = field.asInt();
                                }
                                if ((field = node.findValue("comment")) != null) {
                                    comment = field.asText();
                                }
                                if ((field = node.findValue("maxAge")) != null) {
                                    maxAge = field.asInt();
                                }
                                if ((field = node.findValue("expiry")) != null) {
                                    expiry = new Date(field.asLong());
                                }
                                if ((field = node.findValue("secure")) != null) {
                                    secure = field.asBoolean();
                                }
                                if ((field = node.findValue("httpOnly")) != null) {
                                    httpOnly = field.asBoolean();
                                }
                                NewCookie cookie = new NewCookie(name, value, path, domain, version, comment, maxAge, expiry, secure, httpOnly);
                                rc.put(name, cookie);
                                continue;
                            }
                            throw new IOException("Invalid objects in array");
                        }
                        break block16;
                    }
                    throw new IOException("cookies DB has no array of cookies");
                }
                catch (IOException e) {
                    log.warn("Cannot read cookies from disk", (Throwable)e);
                }
            }
        }
        return rc;
    }

    protected void saveCookies() {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrNode = mapper.createArrayNode();
        for (Map.Entry<String, NewCookie> entry : this.cookies.entrySet()) {
            NewCookie cookie = entry.getValue();
            ObjectNode node = arrNode.addObject();
            node.put("name", cookie.getName());
            node.put("value", cookie.getValue());
            if (cookie.getPath() != null) {
                node.put("path", cookie.getPath());
            } else {
                node.putNull("path");
            }
            if (cookie.getDomain() != null) {
                node.put("domain", cookie.getDomain());
            } else {
                node.putNull("domain");
            }
            node.put("version", cookie.getVersion());
            if (cookie.getComment() != null) {
                node.put("comment", cookie.getComment());
            } else {
                node.putNull("comment");
            }
            node.put("maxAge", cookie.getMaxAge());
            if (cookie.getExpiry() != null) {
                node.put("expiry", cookie.getExpiry().getTime());
            } else {
                node.putNull("expiry");
            }
            node.put("secure", cookie.isSecure());
            node.put("httpOnly", cookie.isHttpOnly());
        }
        try {
            FileUtils.writeStringToFile((File)new File(".", "cookies.db"), (String)arrNode.toString(), (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            log.warn("Cannot write cookies to disk", (Throwable)e);
        }
    }
}

