/*
 * Decompiled with CFR 0.152.
 */
package com.sportdataapi.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import rs.baselib.util.RsDate;
import rs.baselib.util.RsDay;

public class RsDateDeserializer
extends JsonDeserializer<RsDate> {
    public RsDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (!node.isNull()) {
            String value = node.asText();
            if (value.length() == 19) {
                RsDay day = RsDay.getDay((String)(value.substring(0, 4) + value.substring(5, 7) + value.substring(8, 10)));
                RsDate rc = day.getBegin();
                rc.setTimeZone(TimeZone.getTimeZone("UTC"));
                rc.add(11, Integer.valueOf(value.substring(11, 13)).intValue());
                rc.add(12, Integer.valueOf(value.substring(14, 16)).intValue());
                return rc;
            }
            TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(value);
            return new RsDate(Instant.from(ta).getLong(ChronoField.INSTANT_SECONDS));
        }
        return null;
    }
}

