/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpClient {
    private static final Gson GSON = new Gson();
    private final String host;
    private final int port;

    HttpClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public JsonObject post(String path, String name, long value) throws IOException {
        JsonObject data = new JsonObject();
        data.addProperty(name, (Number)value);
        return this.post(path, data);
    }

    public JsonObject post(String path, String name, boolean value) throws IOException {
        JsonObject data = new JsonObject();
        data.addProperty(name, Boolean.valueOf(value));
        return this.post(path, data);
    }

    public JsonObject post(String path, String name, String value) throws IOException {
        JsonObject data = new JsonObject();
        data.addProperty(name, value);
        return this.post(path, data);
    }

    public JsonObject get(String path) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        return HttpClient.readResponse(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject post(String path, JsonObject data) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        try {
            GSON.toJson((JsonElement)data, (Appendable)writer);
        }
        finally {
            writer.close();
        }
        return HttpClient.readResponse(connection);
    }

    public int delete(String path) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.getInputStream().close();
        return connection.getResponseCode();
    }

    private HttpURLConnection getConnection(String path) throws IOException {
        URL url = new URL(String.format("http://%s:%d%s", this.host, this.port, path));
        return (HttpURLConnection)url.openConnection();
    }

    private static JsonObject readResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        if (status < 200 || status > 299) {
            JsonObject error = HttpClient.readAndClose(connection.getErrorStream());
            String errorMsg = String.format("[%d] %s", error.get("status").getAsLong(), error.get("title").getAsString());
            throw new IOException(errorMsg);
        }
        return HttpClient.readAndClose(connection.getInputStream());
    }

    private static JsonObject readAndClose(InputStream is) throws IOException {
        JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(is), JsonObject.class);
        is.close();
        return json;
    }
}

