/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.Proxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToxiproxyClient {
    private final HttpClient httpClient;

    public ToxiproxyClient() {
        this("localhost", 8474);
    }

    public ToxiproxyClient(String host, int port) {
        this.httpClient = new HttpClient(host, port);
    }

    public List<Proxy> getProxies() throws IOException {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        JsonObject object = this.httpClient.get("/proxies");
        for (Map.Entry e : object.entrySet()) {
            proxies.add(new Proxy(this.httpClient, "/proxies/" + (String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonObject()));
        }
        return proxies;
    }

    public Proxy createProxy(String name, String listen, String upstream) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("name", name);
        json.addProperty("listen", listen);
        json.addProperty("upstream", upstream);
        JsonObject result = this.httpClient.post("/proxies", json);
        return new Proxy(this.httpClient, "/proxies/" + name, result);
    }

    public Proxy getProxy(String name) throws IOException {
        JsonObject result = this.httpClient.get("/proxies/" + name);
        return new Proxy(this.httpClient, "/proxies/" + name, result);
    }

    public void reset() throws IOException {
        this.httpClient.get("/reset");
    }
}

