/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model;

import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.toxic.Toxics;
import java.io.IOException;

public class Proxy {
    private final HttpClient httpClient;
    private final String path;
    private String name;
    private String listen;
    private String upstream;
    private boolean enabled;
    private Toxics upstreamToxics;
    private Toxics downstreamToxics;

    public Proxy(HttpClient httpClient, String path, JsonObject json) {
        this.httpClient = httpClient;
        this.path = path;
        this.setFromJson(json);
    }

    private void setFromJson(JsonObject json) {
        this.name = json.get("name").getAsString();
        this.listen = json.get("listen").getAsString();
        this.upstream = json.get("upstream").getAsString();
        this.enabled = json.get("enabled").getAsBoolean();
        this.upstreamToxics = new Toxics(this.httpClient, this.path + "/upstream/toxics", json.get("upstream_toxics"));
        this.downstreamToxics = new Toxics(this.httpClient, this.path + "/downstream/toxics", json.get("downstream_toxics"));
    }

    public String getName() {
        return this.name;
    }

    public String getListen() {
        return this.listen;
    }

    public String getUpstream() {
        return this.upstream;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Toxics upstream() {
        return this.upstreamToxics;
    }

    public Toxics downstream() {
        return this.downstreamToxics;
    }

    public void setListen(String listen) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "listen", listen));
    }

    public void setUpstream(String upstream) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "upstream", upstream));
    }

    public void enable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", true));
    }

    public void disable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", false));
    }

    public void delete() throws IOException {
        this.httpClient.delete(this.path);
    }
}

