/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import java.io.IOException;

public class Bandwidth {
    private final HttpClient httpClient;
    private final String path;
    private boolean enabled;
    private long rate;

    public Bandwidth(HttpClient httpClient, String path, JsonElement json) {
        this.httpClient = httpClient;
        this.path = path;
        if (json != null) {
            this.setFromJson(json.getAsJsonObject());
        }
    }

    private void setFromJson(JsonObject json) {
        this.enabled = json.get("enabled").getAsBoolean();
        this.rate = json.get("rate").getAsLong();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getRate() {
        return this.rate;
    }

    public Bandwidth enable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", true));
        return this;
    }

    public Bandwidth disable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", false));
        return this;
    }

    public Bandwidth setRate(long rate) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "rate", rate));
        return this;
    }
}

