/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import java.io.IOException;

public class Latency {
    private final HttpClient httpClient;
    private final String path;
    private boolean enabled;
    private long latency;
    private long jitter;

    public Latency(HttpClient httpClient, String path, JsonElement json) {
        this.httpClient = httpClient;
        this.path = path;
        if (json != null) {
            this.setFromJson(json.getAsJsonObject());
        }
    }

    private void setFromJson(JsonObject json) {
        this.enabled = json.get("enabled").getAsBoolean();
        this.latency = json.get("latency").getAsLong();
        this.jitter = json.get("jitter").getAsLong();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getLatency() {
        return this.latency;
    }

    public long getJitter() {
        return this.jitter;
    }

    public Latency enable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", true));
        return this;
    }

    public Latency disable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", false));
        return this;
    }

    public Latency setLatency(long latency) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "latency", latency));
        return this;
    }

    public Latency setJitter(long jitter) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "jitter", jitter));
        return this;
    }
}

