/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import java.io.IOException;

public class Slicer {
    private final HttpClient httpClient;
    private final String path;
    private boolean enabled;
    private long averageSize;
    private long sizeVariation;
    private long delay;

    public Slicer(HttpClient httpClient, String path, JsonElement json) {
        this.httpClient = httpClient;
        this.path = path;
        if (json != null) {
            this.setFromJson(json.getAsJsonObject());
        }
    }

    private void setFromJson(JsonObject json) {
        this.enabled = json.get("enabled").getAsBoolean();
        this.averageSize = json.get("average_size").getAsLong();
        this.sizeVariation = json.get("size_variation").getAsLong();
        this.delay = json.get("delay").getAsLong();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getAverageSize() {
        return this.averageSize;
    }

    public long getSizeVariation() {
        return this.sizeVariation;
    }

    public long getDelay() {
        return this.delay;
    }

    public Slicer enable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", true));
        return this;
    }

    public Slicer disable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", false));
        return this;
    }

    public Slicer setAverageSize(long averageSize) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "average_size", averageSize));
        return this;
    }

    public Slicer setSizeVariation(long sizeVariation) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "size_variation", sizeVariation));
        return this;
    }

    public Slicer setDelay(long delay) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "delay", delay));
        return this;
    }
}

