/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import java.io.IOException;

public class SlowClose {
    private final HttpClient httpClient;
    private final String path;
    private boolean enabled;
    private long delay;

    public SlowClose(HttpClient httpClient, String path, JsonElement json) {
        this.httpClient = httpClient;
        this.path = path;
        if (json != null) {
            this.setFromJson(json.getAsJsonObject());
        }
    }

    private void setFromJson(JsonObject json) {
        this.enabled = json.get("enabled").getAsBoolean();
        this.delay = json.get("delay").getAsLong();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getDelay() {
        return this.delay;
    }

    public SlowClose enable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", true));
        return this;
    }

    public SlowClose disable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", false));
        return this;
    }

    public SlowClose setDelay(long delay) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "delay", delay));
        return this;
    }
}

