/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import java.io.IOException;

public class Timeout {
    private final HttpClient httpClient;
    private final String path;
    private boolean enabled;
    private long timeout;

    public Timeout(HttpClient httpClient, String path, JsonElement json) {
        this.httpClient = httpClient;
        this.path = path;
        if (json != null) {
            this.setFromJson(json.getAsJsonObject());
        }
    }

    private void setFromJson(JsonObject json) {
        this.enabled = json.get("enabled").getAsBoolean();
        this.timeout = json.get("timeout").getAsLong();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Timeout enable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", true));
        return this;
    }

    public Timeout disable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", false));
        return this;
    }

    public Timeout setTimeout(long timeout) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "timeout", timeout));
        return this;
    }
}

