/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model.toxic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.toxic.Bandwidth;
import eu.rekawek.toxiproxy.model.toxic.Latency;
import eu.rekawek.toxiproxy.model.toxic.Slicer;
import eu.rekawek.toxiproxy.model.toxic.SlowClose;
import eu.rekawek.toxiproxy.model.toxic.Timeout;

public class Toxics {
    private final HttpClient httpClient;
    private final String path;
    private Latency latency;
    private Bandwidth bandwidth;
    private SlowClose slowClose;
    private Timeout timeout;
    private Slicer slicer;

    public Toxics(HttpClient httpClient, String path, JsonElement json) {
        this.httpClient = httpClient;
        this.path = path;
        if (json != null) {
            this.setFromJson(json.getAsJsonObject());
        }
    }

    private void setFromJson(JsonObject json) {
        this.latency = new Latency(this.httpClient, this.path + "/latency", json.get("latency"));
        this.bandwidth = new Bandwidth(this.httpClient, this.path + "/bandwidth", json.get("bandwidth"));
        this.slowClose = new SlowClose(this.httpClient, this.path + "/slow_close", json.get("slow_close"));
        this.timeout = new Timeout(this.httpClient, this.path + "/timeout", json.get("timeout"));
        this.slicer = new Slicer(this.httpClient, this.path + "/slicer", json.get("slicer"));
    }

    public Latency latency() {
        return this.latency;
    }

    public Bandwidth bandwidth() {
        return this.bandwidth;
    }

    public SlowClose slowClose() {
        return this.slowClose;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public Slicer slicer() {
        return this.slicer;
    }
}

