/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.Proxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ToxiproxyClient {
    private final HttpClient httpClient;
    private final Set<Proxy> proxies = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public ToxiproxyClient() {
        this("localhost", 8474);
    }

    public ToxiproxyClient(String host, int port) {
        this.httpClient = new HttpClient(host, port);
    }

    public List<Proxy> getProxies() throws IOException {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        JsonObject object = this.httpClient.get("/proxies");
        for (Map.Entry e : object.entrySet()) {
            proxies.add(new Proxy(this.httpClient, "/proxies/" + (String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonObject()));
        }
        return proxies;
    }

    public Proxy createProxy(String name, String listen, String upstream) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("name", name);
        json.addProperty("listen", listen);
        json.addProperty("upstream", upstream);
        JsonObject result = this.httpClient.post("/proxies", json);
        return this.newProxyInstance(name, result);
    }

    public Proxy getProxy(String name) throws IOException {
        JsonObject result = this.httpClient.get("/proxies/" + name);
        return this.newProxyInstance(name, result);
    }

    public Proxy getProxyOrNull(String name) {
        try {
            return this.getProxy(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Proxy newProxyInstance(String name, JsonObject json) {
        Proxy p = new Proxy(this.httpClient, "/proxies/" + name, json);
        this.proxies.add(p);
        return p;
    }

    public void reset() throws IOException {
        this.httpClient.post("/reset");
        for (Proxy p : this.proxies) {
            p.reset();
        }
    }

    public String version() throws IOException {
        return this.httpClient.getPlain("/version").trim();
    }
}

