/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core;

import eu.seaclouds.platform.planner.core.DamGeneratorConfigBag;
import eu.seaclouds.platform.planner.core.application.ApplicationFacade;
import eu.seaclouds.platform.planner.core.application.agreements.AgreementGenerator;
import eu.seaclouds.platform.planner.core.utils.YamlParser;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamGenerator {
    static Logger log = LoggerFactory.getLogger(DamGenerator.class);
    public static final String TYPE = "type";
    public static final String POLICIES = "policies";
    public static final String GROUPS = "groups";
    public static final String MEMBERS = "members";
    public static final String ID = "id";
    public static final String APPLICATION = "application";
    public static final String TOPOLOGY_TEMPLATE = "topology_template";
    public static final String NODE_TEMPLATES = "node_templates";
    public static final String NODE_TYPES = "node_types";
    public static final String PROPERTIES = "properties";
    public static final String BROOKLYN_POLICY_TYPE = "brooklyn.location";
    public static final String SEACLOUDS_APPLICATION_CONFIGURATION = "seaclouds_configuration_policy";
    public static final String REQUIREMENTS = "requirements";
    public static final String HOST = "host";
    private final DamGeneratorConfigBag configBag;
    private Map<String, Object> template;
    private Map<String, Object> originalAdp;
    private AgreementGenerator agreementGenerator;

    public DamGenerator(DamGeneratorConfigBag configBag) {
        this.configBag = configBag;
        this.init();
    }

    private void init() {
        this.agreementGenerator = new AgreementGenerator(this.configBag.getSlaEndpoint());
    }

    public String generateDam(String adp) {
        this.originalAdp = this.normalizeComputeTypes(YamlParser.load(adp));
        ApplicationFacade applicationFacade = new ApplicationFacade(this.originalAdp, this.configBag);
        applicationFacade.setAgreementGenerator(this.agreementGenerator);
        applicationFacade.generateDam();
        String generatedDam = applicationFacade.templateToString();
        this.template = YamlParser.load(generatedDam);
        this.customize();
        return YamlParser.dump(this.template);
    }

    private void customize() {
        this.relationManagement();
        this.manageNodeTypes();
        this.manageGroups();
    }

    private void manageNodeTypes() {
        if (this.template.containsKey(NODE_TYPES)) {
            this.template.remove(NODE_TYPES);
        }
    }

    private Map<String, Object> normalizeComputeTypes(Map<String, Object> adpTemplate) {
        Map topologyTemplate = (Map)adpTemplate.get(TOPOLOGY_TEMPLATE);
        Map nodeTemplates = (Map)topologyTemplate.get(NODE_TEMPLATES);
        for (Map.Entry nodeTemplateEntry : nodeTemplates.entrySet()) {
            Map nodeTemplate = (Map)nodeTemplateEntry.getValue();
            String nodeTemplateType = (String)nodeTemplate.get(TYPE);
            if (!nodeTemplateType.contains("seaclouds.nodes.Compute")) continue;
            nodeTemplate.put(TYPE, "seaclouds.nodes.Compute");
        }
        return adpTemplate;
    }

    private void manageGroups() {
        Map groups = (Map)this.template.remove(GROUPS);
        ((Map)this.template.get(TOPOLOGY_TEMPLATE)).put(GROUPS, groups);
    }

    public void relationManagement() {
        Map topologyTemplate = (Map)this.template.get(TOPOLOGY_TEMPLATE);
        Map nodeTemplates = (Map)topologyTemplate.get(NODE_TEMPLATES);
        for (Map.Entry nodeTemplateEntry : nodeTemplates.entrySet()) {
            Map nodeTemplate = (Map)nodeTemplateEntry.getValue();
            List requirements = (List)nodeTemplate.get(REQUIREMENTS);
            MutableList fixedRequirements = MutableList.of();
            if (requirements == null) continue;
            for (Map requirement : requirements) {
                if (requirement.containsKey(HOST)) {
                    fixedRequirements.add(requirement);
                    continue;
                }
                if (!requirement.containsKey("dbConnection") && !requirement.containsKey("endpoint_configuration")) continue;
                fixedRequirements.add(requirement);
            }
            if (fixedRequirements.isEmpty()) {
                nodeTemplate.remove(REQUIREMENTS);
                continue;
            }
            nodeTemplate.put(REQUIREMENTS, fixedRequirements);
        }
    }

    public void setAgreementGenerator(AgreementGenerator agreementGenerator) {
        this.agreementGenerator = agreementGenerator;
    }
}

