/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamGeneratorConfigBag {
    static Logger log = LoggerFactory.getLogger(DamGeneratorConfigBag.class);
    private String monitorUrl;
    private String monitorPort;
    private String slaEndpoint;
    private String influxdbUrl;
    private String influxdbPort;
    private String influxdbDatabase;
    private String influxdbUsername;
    private String influxdbPassword;
    private String grafanaUsername;
    private String grafanaPassword;
    private String grafanaEndpoint;
    private URL monitorEndPoint;
    private URL influxDbEndpoint;

    public DamGeneratorConfigBag(Builder builder) {
        this.monitorUrl = builder.monitorUrl;
        this.monitorPort = builder.monitorPort;
        this.slaEndpoint = builder.slaUrl;
        this.influxdbUrl = builder.influxdbUrl;
        this.influxdbPort = builder.influxdbPort;
        this.influxdbDatabase = builder.influxdbDatabase;
        this.influxdbUsername = builder.influxdbUsername;
        this.influxdbPassword = builder.influxdbPassword;
        this.grafanaUsername = builder.grafanaUsername;
        this.grafanaPassword = builder.grafanaPassword;
        this.grafanaEndpoint = builder.grafanaEndpoint;
        this.init();
    }

    private void init() {
        this.monitorEndPoint = this.createMonitoringEndpoint();
        this.influxDbEndpoint = this.createInfluxDbEndpoint();
    }

    private URL createMonitoringEndpoint() {
        try {
            return new URL("http://" + this.monitorUrl + ":" + this.monitorPort + "");
        }
        catch (MalformedURLException e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error creating MonitoringEndpoint: http://" + this.monitorUrl + ":" + this.monitorPort);
            return null;
        }
    }

    private URL createInfluxDbEndpoint() {
        try {
            return new URL("http://" + this.influxdbUrl + ":" + this.influxdbPort + "");
        }
        catch (MalformedURLException e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error creating InfluxDbEndpoint: http://" + this.influxdbUrl + ":" + this.influxdbPort);
            return null;
        }
    }

    public String getSlaEndpoint() {
        return this.slaEndpoint;
    }

    public String getMonitorUrl() {
        return this.monitorUrl;
    }

    public String getMonitorPort() {
        return this.monitorPort;
    }

    public String getInfluxdbUrl() {
        return this.influxdbUrl;
    }

    public String getInfluxdbPort() {
        return this.influxdbPort;
    }

    public String getInfluxdbDatabase() {
        return this.influxdbDatabase;
    }

    public String getInfluxdbUsername() {
        return this.influxdbUsername;
    }

    public String getInfluxdbPassword() {
        return this.influxdbPassword;
    }

    public String getGrafanaUsername() {
        return this.grafanaUsername;
    }

    public String getGrafanaPassword() {
        return this.grafanaPassword;
    }

    public String getGrafanaEndpoint() {
        return this.grafanaEndpoint;
    }

    public URL getMonitorEndpoint() {
        return this.monitorEndPoint;
    }

    public URL getInfluxDbEndpoint() {
        return this.influxDbEndpoint;
    }

    public static class Builder {
        private String monitorUrl;
        private String monitorPort;
        private String slaUrl;
        private String influxdbUrl;
        private String influxdbPort;
        private String grafanaEndpoint;
        private String influxdbDatabase;
        private String influxdbUsername;
        private String influxdbPassword;
        private String grafanaUsername;
        private String grafanaPassword;

        public Builder monitorUrl(String monitorUrl) {
            this.monitorUrl = monitorUrl;
            return this;
        }

        public Builder monitorPort(String monitorPort) {
            this.monitorPort = monitorPort;
            return this;
        }

        public Builder slaUrl(String slaUrl) {
            this.slaUrl = slaUrl;
            return this;
        }

        public Builder influxdbUrl(String influxdbUrl) {
            this.influxdbUrl = influxdbUrl;
            return this;
        }

        public Builder influxdbPort(String influxdbPort) {
            this.influxdbPort = influxdbPort;
            return this;
        }

        public Builder influxdbDatabase(String influxdbDatabase) {
            this.influxdbDatabase = influxdbDatabase;
            return this;
        }

        public Builder influxdbUsername(String influxdbUsername) {
            this.influxdbUsername = influxdbUsername;
            return this;
        }

        public Builder influxdbPassword(String influxdbPassword) {
            this.influxdbPassword = influxdbPassword;
            return this;
        }

        public Builder grafanaUsername(String grafanaUsername) {
            this.grafanaUsername = grafanaUsername;
            return this;
        }

        public Builder grafanaPassword(String grafanaPassword) {
            this.grafanaPassword = grafanaPassword;
            return this;
        }

        public Builder grafanaEndpoint(String grafanaEndpoint) {
            this.grafanaEndpoint = grafanaEndpoint;
            return this;
        }

        public DamGeneratorConfigBag build() {
            return new DamGeneratorConfigBag(this);
        }
    }
}

