/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core;

import alien4cloud.model.topology.NodeTemplate;
import alien4cloud.tosca.model.ArchiveRoot;
import alien4cloud.tosca.parser.ParsingException;
import alien4cloud.tosca.parser.ParsingResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.seaclouds.common.tosca.ToscaSerializer;
import eu.seaclouds.planner.matchmaker.Matchmaker;
import eu.seaclouds.planner.matchmaker.Pair;
import eu.seaclouds.platform.planner.core.utils.HttpHelper;
import eu.seaclouds.platform.planner.optimizer.Optimizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Planner {
    static Logger log = LoggerFactory.getLogger(Planner.class);
    private static final String DISCOVERER_PATH = "discoverer/";
    private final String discovererURL;
    private List<String> deployableProviders = null;
    private HttpHelper discovererClient;

    public Planner() {
        this.discovererURL = null;
    }

    public Planner(String discovererURL) {
        this.discovererURL = discovererURL + DISCOVERER_PATH;
        this.discovererClient = new HttpHelper(this.discovererURL);
    }

    public Planner(String discovererURL, List<String> deployableProviders) {
        this(discovererURL);
        this.deployableProviders = deployableProviders;
    }

    private String generateMMOutput2(Map<String, HashSet<String>> mmResult, Map<String, Pair<NodeTemplate, String>> offerings) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList singleRes = new ArrayList();
        Yaml yml = new Yaml();
        for (String moduleName : mmResult.keySet()) {
            ArrayList suitableList = new ArrayList();
            for (String id : mmResult.get(moduleName)) {
                String off = (String)offerings.get((Object)id).second;
                HashMap<String, String> innerMap = new HashMap<String, String>();
                innerMap.put(id, off);
                suitableList.add(innerMap);
            }
            HashMap finalRes = new HashMap();
            finalRes.put(moduleName, suitableList);
            singleRes.add(finalRes);
        }
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(singleRes);
    }

    private String generateMMOutput(Map<String, HashSet<String>> mmResult, Map<String, Pair<NodeTemplate, String>> offerings) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList singleRes = new ArrayList();
        Yaml yml = new Yaml();
        for (String moduleName : mmResult.keySet()) {
            ArrayList suitableList = new ArrayList();
            for (String id : mmResult.get(moduleName)) {
                String off = (String)offerings.get((Object)id).second;
                HashMap<String, String> innerMap = new HashMap<String, String>();
                Map tosca = (Map)yml.load(off);
                Object o = ((Map)tosca.get("topology_template")).get("node_templates");
                String od = yml.dump(o);
                innerMap.put(id, od);
                suitableList.add(innerMap);
            }
            HashMap finalRes = new HashMap();
            finalRes.put(moduleName, suitableList);
            singleRes.add(finalRes);
        }
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(singleRes);
    }

    public String[] fetchAndPlan(String aam) throws ParsingException, IOException {
        String offerings = this.fetchOfferings();
        return this.plan(aam, offerings);
    }

    public String[] plan(String aam, String uniqueOfferingsTosca) throws ParsingException, IOException {
        log.info("Planning for aam: \n" + aam);
        log.info("Getting Offeing Step: Start");
        Map<String, Pair<NodeTemplate, String>> offerings = this.parseOfferings(uniqueOfferingsTosca);
        log.info("Getting Offeing Step: Complete");
        log.info("\nNot deployable offering have been filtered!");
        log.info("\nDeployable offerings have location: " + this.deployableProviders);
        log.info("Got " + offerings.size() + " offerings from discoverer:");
        log.info("Matchmaking Step: Start");
        Matchmaker mm = new Matchmaker();
        Map matchingOfferings = mm.match(ToscaSerializer.fromTOSCA((String)aam), offerings);
        log.info("Matchmaking Step: Complete");
        String mmOutput = "";
        try {
            mmOutput = this.generateMMOutput2(matchingOfferings, offerings);
        }
        catch (JsonProcessingException e) {
            log.error("Error preparing matchmaker output for optimization", (Throwable)e);
        }
        for (String s : matchingOfferings.keySet()) {
            log.info("Module " + s + "has matching offerings: " + matchingOfferings.get(s));
        }
        log.info("Optimization Step: Start");
        log.info("Calling optimizer with suitable offerings: \n" + mmOutput);
        Optimizer optimizer = new Optimizer();
        String[] outputPlans = optimizer.optimize(aam, mmOutput);
        log.info("Optimzer result: " + Arrays.asList(outputPlans));
        log.info("Optimization Step: Complete");
        return outputPlans;
    }

    private Map<String, HashSet<String>> filterOffering(Map<String, HashSet<String>> matchingResult, List<String> modulesToFilter) {
        throw new UnsupportedOperationException();
    }

    public String[] fetchAndRePlan(String aam, List<String> modulesToFilter) throws ParsingException, IOException {
        String offerings = this.fetchOfferings();
        return this.rePlan(aam, offerings, modulesToFilter);
    }

    public String[] rePlan(String aam, String uniqueOfferingsTosca, List<String> modulesToFilter) throws ParsingException, IOException {
        log.info("Getting Offeing Step: Start");
        Map<String, Pair<NodeTemplate, String>> offerings = this.parseOfferings(uniqueOfferingsTosca);
        log.info("Getting Offeing Step: Complete");
        log.info("Matchmaking Step: Start");
        Matchmaker mm = new Matchmaker();
        Map<String, HashSet<String>> matchingOfferings = mm.match(ToscaSerializer.fromTOSCA((String)aam), offerings);
        matchingOfferings = this.filterOffering(matchingOfferings, modulesToFilter);
        log.info("Matchmaking Step: Complete");
        String mmOutput = "";
        try {
            mmOutput = this.generateMMOutput2(matchingOfferings, offerings);
        }
        catch (JsonProcessingException e) {
            log.error("Error preparing matchmaker output for optimization", (Throwable)e);
        }
        log.info("Optimization Step: Start");
        Optimizer optimizer = new Optimizer();
        String[] outputPlans = optimizer.optimize(aam, mmOutput);
        log.info("Optimization Step: Complete");
        return outputPlans;
    }

    private List<NameValuePair> getReqParams(NameValuePair ... params) {
        ArrayList<NameValuePair> reqParams = new ArrayList<NameValuePair>();
        for (NameValuePair nvp : params) {
            reqParams.add(nvp);
        }
        return reqParams;
    }

    private String fetchOfferings() {
        DiscovererFetchallResult allOfferings = null;
        try {
            String discovererOutput = this.discovererClient.getRequest("fetch_all", Collections.EMPTY_LIST);
            ObjectMapper mapper = new ObjectMapper();
            allOfferings = (DiscovererFetchallResult)mapper.readValue(discovererOutput, DiscovererFetchallResult.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String offerings = allOfferings.offering;
        return offerings;
    }

    private Map<String, Pair<NodeTemplate, String>> parseOfferings(String offerings) {
        HashMap<String, Pair<NodeTemplate, String>> map = new HashMap<String, Pair<NodeTemplate, String>>();
        try {
            ParsingResult offeringRes = ToscaSerializer.fromTOSCA((String)offerings);
            Map offering = ((ArchiveRoot)offeringRes.getResult()).getTopology().getNodeTemplates();
            Yaml yml = new Yaml();
            Map adpYaml = (Map)yml.load(offerings);
            Map nodeTemplates = (Map)((Map)adpYaml.get("topology_template")).get("node_templates");
            for (String node : offering.keySet()) {
                Map properties = (Map)((Map)nodeTemplates.get(node)).get("properties");
                String location = (String)properties.get("location");
                if (this.deployableProviders != null && !this.deployableProviders.contains(location)) continue;
                NodeTemplate nt = (NodeTemplate)offering.get(node);
                HashMap offerMap = new HashMap();
                offerMap.put(node, nodeTemplates.get(node));
                String offerDump = yml.dump(offerMap);
                map.put(node, (Pair<NodeTemplate, String>)new Pair((Object)nt, (Object)offerDump));
            }
        }
        catch (Exception e) {
            log.error(e.getCause().getMessage());
        }
        return map;
    }

    private Map<String, Pair<NodeTemplate, String>> getOfferingsFromDiscoverer() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String idsString = this.discovererClient.getRequest("fetch", Collections.EMPTY_LIST);
        String[] discoveredIds = (String[])mapper.readValue(idsString, String[].class);
        HashMap<String, Pair<NodeTemplate, String>> offerings = new HashMap<String, Pair<NodeTemplate, String>>();
        for (String offerId : discoveredIds) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("oid", offerId));
            Pair<String, String> discovererResponse = this.discovererClient.postRequestWithParams("fetch", params);
            if (!((String)discovererResponse.first).equals("200")) continue;
            String offerStr = (String)discovererResponse.second;
            Offering offer = (Offering)mapper.readValue(offerStr, Offering.class);
            try {
                NodeTemplate nt = (NodeTemplate)((ArchiveRoot)ToscaSerializer.fromTOSCA((String)offer.offering).getResult()).getTopology().getNodeTemplates().values().iterator().next();
                offerings.put(offerId, (Pair<NodeTemplate, String>)new Pair((Object)nt, (Object)offer.offering));
            }
            catch (ParsingException e) {
                // empty catch block
            }
        }
        return offerings;
    }

    public static class Offering {
        public String offering;
        public String offering_id;

        @JsonProperty
        public void setOffering(String offering) {
            this.offering = offering;
        }

        @JsonProperty
        public String getOffering() {
            return this.offering;
        }

        @JsonProperty
        public void setOffering_id(String offering_id) {
            this.offering_id = offering_id;
        }

        @JsonProperty
        public String getOffering_id() {
            return this.offering_id;
        }
    }

    public static class DiscovererFetchallResult {
        public String offering;
        public String[] offering_ids;
    }
}

