/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application;

import eu.seaclouds.monitor.monitoringdamgenerator.MonitoringInfo;
import eu.seaclouds.platform.planner.core.DamGeneratorConfigBag;
import eu.seaclouds.platform.planner.core.application.ApplicationFacadeDecoratorApplicator;
import eu.seaclouds.platform.planner.core.application.ApplicationMetadataGenerator;
import eu.seaclouds.platform.planner.core.application.agreements.AgreementGenerator;
import eu.seaclouds.platform.planner.core.application.topology.TopologyTemplateFacade;
import eu.seaclouds.platform.planner.core.application.topology.modifier.relation.TopologFacadeyModifierApplicator;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplate;
import eu.seaclouds.platform.planner.core.utils.YamlParser;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationFacade {
    static Logger log = LoggerFactory.getLogger(ApplicationFacade.class);
    private final Map<String, Object> adp;
    private final DamGeneratorConfigBag configBag;
    private Map<String, Object> template;
    private TopologyTemplateFacade topologyTemplate;
    private Map<String, Object> nodeTypes;
    private AgreementGenerator agreementGenerator;
    private String applicationSlaId;
    private MonitoringInfo monitoringInfo;

    public ApplicationFacade(Map<String, Object> adp, DamGeneratorConfigBag configBag) {
        this.adp = adp;
        this.template = MutableMap.copyOf(adp);
        this.topologyTemplate = new TopologyTemplateFacade(adp);
        this.configBag = configBag;
        this.init();
    }

    private void init() {
        this.nodeTypes = this.template.get("node_types") != null ? (Map)this.template.get("node_types") : MutableMap.of();
        this.agreementGenerator = new AgreementGenerator(this.configBag.getSlaEndpoint());
    }

    public void addGroup(String groupName, Map<String, Object> groupValue) {
        this.getGroups().put(groupName, groupValue);
    }

    public Map<String, Object> getGroups() {
        return (Map)this.template.get("groups");
    }

    public void addSlaInformation(String agreementId) {
        this.applicationSlaId = agreementId;
    }

    public DamGeneratorConfigBag getConfigBag() {
        return this.configBag;
    }

    public AgreementGenerator getAgreementGenerator() {
        return this.agreementGenerator;
    }

    public void setAgreementGenerator(AgreementGenerator agreementGenerator) {
        this.agreementGenerator = agreementGenerator;
    }

    public MonitoringInfo getMonitoringInfo() {
        return this.monitoringInfo;
    }

    public void addMonitoringInfo(MonitoringInfo monitoringInfo) {
        this.monitoringInfo = monitoringInfo;
        this.template = YamlParser.load(monitoringInfo.getReturnedAdp());
        this.topologyTemplate.updateNoExistNodeTemplate(this.template);
        this.updateNodeTemplates();
    }

    public String getApplicationSlaId() {
        return this.applicationSlaId;
    }

    public String templateToString() {
        return YamlParser.dump(this.template);
    }

    public void generateDam() {
        this.normalizeMetadata();
        this.createTopologyTemplate();
        this.applyDecorators();
        this.applyTopologyModifiers();
        this.joinPlatformsAndHostedNodeTemplates();
        this.addPoliciesLocations();
    }

    private void normalizeMetadata() {
        ApplicationMetadataGenerator applicationMetadata = new ApplicationMetadataGenerator(this.template);
        applicationMetadata.addMetadataMetadataToTemplate();
    }

    private void createTopologyTemplate() {
        this.topologyTemplate = new TopologyTemplateFacade(this.adp);
        this.updateTypesAndTemplates();
    }

    private void updateTypesAndTemplates() {
        this.updateNodeTypes(this.topologyTemplate.getRequiredNodeTypes());
        this.updateNodeTemplates();
    }

    private void joinPlatformsAndHostedNodeTemplates() {
        this.topologyTemplate.joinPlatformNodeTemplates();
        this.updateNodeTemplates();
    }

    private void applyDecorators() {
        ApplicationFacadeDecoratorApplicator applicator = new ApplicationFacadeDecoratorApplicator();
        applicator.applyDecorators(this);
    }

    private void applyTopologyModifiers() {
        this.topologyTemplate.applyModifierApplicator(new TopologFacadeyModifierApplicator());
    }

    private void addPoliciesLocations() {
        Map<String, Object> locationGroups = this.topologyTemplate.getLocationPoliciesGroups();
        this.addGroups(locationGroups);
    }

    private void updateNodeTemplates() {
        Map<String, Object> transformedNodeTemplates = this.topologyTemplate.getNodeTransformedNodeTemplates();
        this.setNodeTemplates(transformedNodeTemplates);
    }

    private Map<String, Object> getNodeTypes() {
        return this.nodeTypes;
    }

    private void setNodeTemplates(Map<String, Object> nodeTemplates) {
        Map topologyTem = (Map)this.template.get("topology_template");
        topologyTem.put("node_templates", nodeTemplates);
    }

    private void addGroups(Map<String, Object> groups) {
        for (Map.Entry<String, Object> groupEntry : groups.entrySet()) {
            String groupName = groupEntry.getKey();
            Map groupValue = (Map)groupEntry.getValue();
            this.addGroup(groupName, groupValue);
        }
    }

    private void setNodeTypes(Map<String, Object> nodeTypes) {
        this.nodeTypes = nodeTypes;
        this.template.put("node_types", nodeTypes);
    }

    private void updateNodeTypes(Map<String, Object> newNodeTypes) {
        Map<String, Object> currentNodeTypes = this.getNodeTypes();
        Map<String, NodeTemplate> nodeTemplates = this.topologyTemplate.getNodeTemplates();
        MutableMap usedNodeTemplates = MutableMap.of();
        for (Map.Entry<String, NodeTemplate> nodeTemplateEntry : nodeTemplates.entrySet()) {
            NodeTemplate nodeTemplate = nodeTemplateEntry.getValue();
            String moduleType = nodeTemplate.getModuleType();
            if (!currentNodeTypes.containsKey(moduleType)) continue;
            String targetType = nodeTemplate.getType();
            if (targetType != null) {
                if (nodeTemplate.getNodeTypeDefinition() != null) {
                    usedNodeTemplates.put(targetType, nodeTemplate.getNodeTypeDefinition());
                    continue;
                }
                log.error("TargetType definition " + targetType + "was not found" + "so it will not added to DAM");
                continue;
            }
            usedNodeTemplates.put(moduleType, newNodeTypes.get(moduleType));
        }
        this.setNodeTypes((Map<String, Object>)usedNodeTemplates);
    }
}

