/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application;

import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;

public class ApplicationMetadataGenerator {
    public static final String IMPORTS = "imports";
    public static final String TOSCA_NORMATIVE_TYPES = "tosca-normative-types";
    public static final String TOSCA_NORMATIVE_TYPES_VERSION = "1.0.0.wd06-SNAPSHOT";
    public static final String SEACLOUDS_NODE_TYPES = "seaclouds-types";
    public static final String SEACLOUDS_NODE_TYPES_VERSION = "0.8.0-SNAPSHOT";
    public static final String TEMPLATE_NAME = "template_name";
    public static final String TEMPLATE_NAME_PREFIX = "seaclouds.app.";
    public static final String TEMPLATE_VERSION = "template_version";
    public static final String DEFAULT_TEMPLATE_VERSION = "1.0.0-SNAPSHOT";
    private final Map<String, Object> template;
    private String templateName;
    private String templateVersion;
    private List<String> imports;

    public ApplicationMetadataGenerator(Map<String, Object> template) {
        this.template = template;
        this.init();
    }

    private void init() {
        this.initTemplateName();
        this.initTemplateVersion();
        this.initImports();
    }

    private void initTemplateVersion() {
        this.templateVersion = Strings.isBlank((CharSequence)((String)this.template.get(TEMPLATE_VERSION))) ? DEFAULT_TEMPLATE_VERSION : (String)this.template.get(TEMPLATE_VERSION);
    }

    private void initTemplateName() {
        this.templateName = Strings.isBlank((CharSequence)((String)this.template.get(TEMPLATE_NAME))) ? TEMPLATE_NAME_PREFIX + Identifiers.makeRandomId((int)8) : (String)this.template.get(TEMPLATE_NAME);
    }

    private void initImports() {
        this.imports = this.template.get(IMPORTS) != null ? (List)this.template.get(IMPORTS) : MutableList.of();
        this.fixNormativeTypesVersion();
        this.imports.add("seaclouds-types:0.8.0-SNAPSHOT");
    }

    private void fixNormativeTypesVersion() {
        String importedNormativeTypes = null;
        for (String dependency : this.imports) {
            if (!dependency.contains(TOSCA_NORMATIVE_TYPES)) continue;
            importedNormativeTypes = dependency;
        }
        if (importedNormativeTypes != null && !importedNormativeTypes.equals("tosca-normative-types:1.0.0.wd06-SNAPSHOT")) {
            this.imports.remove(importedNormativeTypes);
            this.imports.add("tosca-normative-types:1.0.0.wd06-SNAPSHOT");
        }
    }

    public Map<String, Object> addMetadataMetadataToTemplate() {
        this.addTemplateImports();
        this.addTemplateName();
        this.addTemplateVersion();
        return this.template;
    }

    private void addTemplateName() {
        this.template.put(TEMPLATE_NAME, this.templateName);
    }

    private void addTemplateVersion() {
        this.template.put(TEMPLATE_VERSION, this.templateVersion);
    }

    private void addTemplateImports() {
        this.template.put(IMPORTS, this.imports);
    }
}

