/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.agreements;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import eu.seaclouds.platform.planner.core.application.ApplicationMonitorId;
import eu.seaclouds.platform.planner.core.utils.HttpHelper;
import eu.seaclouds.platform.planner.core.utils.YamlParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgreementGenerator {
    static Logger log = LoggerFactory.getLogger(AgreementGenerator.class);
    private static final String SLA_GEN_OP = "/seaclouds/templates";
    private static final String GET_AGREEMENT_OP = "/seaclouds/commands/fromtemplate";
    private String slaUrl;

    public AgreementGenerator(String slaUrl) {
        this.slaUrl = slaUrl;
    }

    public String generateAgreeemntId(String templateDescription) {
        String result = null;
        Map<String, Object> template = YamlParser.load(templateDescription);
        String slaInfoResponse = new HttpHelper(this.slaUrl).postInBody(SLA_GEN_OP, YamlParser.dump(template));
        Preconditions.checkNotNull((Object)slaInfoResponse, (Object)"Error getting SLA info");
        try {
            ApplicationMonitorId applicationMonitoringId = (ApplicationMonitorId)new ObjectMapper().readValue(slaInfoResponse, ApplicationMonitorId.class);
            result = applicationMonitoringId.getId();
        }
        catch (IOException e) {
            log.error("Error AgreementTemplateId during dam generation {}", (Object)this);
        }
        return result;
    }

    public String getAgreement(String applicationMonitorId) {
        MutableList paremeters = MutableList.of((Object)new BasicNameValuePair("templateId", applicationMonitorId));
        return new HttpHelper(this.slaUrl).getRequest(GET_AGREEMENT_OP, (List<NameValuePair>)paremeters);
    }
}

