/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.decorators;

import eu.seaclouds.platform.planner.core.application.ApplicationFacade;
import eu.seaclouds.platform.planner.core.application.decorators.ApplicationFacadeDecorator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MissingPolicyTypesDecorator
implements ApplicationFacadeDecorator {
    @Override
    public void apply(ApplicationFacade applicationFacade) {
        Map<String, Object> groups = applicationFacade.getGroups();
        this.addPoliciesTypeIfNotPresent(groups);
    }

    public void addPoliciesTypeIfNotPresent(Map<String, Object> groups) {
        for (Map.Entry<String, Object> entryGroup : groups.entrySet()) {
            List policies = (List)((Map)entryGroup.getValue()).get("policies");
            if (policies == null) continue;
            for (Map policy : policies) {
                Map<String, Object> policyProperties;
                String policyName = this.getPolicyName(policy);
                if (this.isLocationPolicy(policy) || policy.get(policyName) instanceof String || this.getPolicyType(policyProperties = this.getPolicyProperties(policy)) != null) continue;
                policyProperties.put("type", "seaclouds.policies." + policyName);
            }
        }
    }

    private String getPolicyType(Map<String, Object> policyProperties) {
        return (String)policyProperties.get("type");
    }

    private String getPolicyName(Map<String, Object> policy) {
        Iterator<Map.Entry<String, Object>> iterator;
        if (policy != null && (iterator = policy.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Object> policyEntry = iterator.next();
            return policyEntry.getKey();
        }
        return null;
    }

    private boolean isLocationPolicy(Map<String, Object> policy) {
        return policy.containsKey("brooklyn.location");
    }

    private Map<String, Object> getPolicyProperties(Map<String, Object> policy) {
        Iterator<Map.Entry<String, Object>> iterator;
        if (policy != null && (iterator = policy.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Object> policyEntry = iterator.next();
            return (Map)policyEntry.getValue();
        }
        return null;
    }
}

