/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.decorators;

import eu.seaclouds.monitor.monitoringdamgenerator.MonitoringDamGenerator;
import eu.seaclouds.monitor.monitoringdamgenerator.MonitoringInfo;
import eu.seaclouds.platform.planner.core.DamGeneratorConfigBag;
import eu.seaclouds.platform.planner.core.application.ApplicationFacade;
import eu.seaclouds.platform.planner.core.application.decorators.ApplicationFacadeDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;

public class MonitoringInformationDecorator
implements ApplicationFacadeDecorator {
    public static final String MONITOR_INFO_GROUPNAME = "monitoringInformation";
    public static final String SEACLOUDS_MONITORING_RULES_ID_POLICY = "seaclouds.policies.monitoringrules";
    public static final String MONITORING_RULES_POLICY_NAME = "monitoringrules.information.policy";
    private DamGeneratorConfigBag configBag;
    private ApplicationFacade applicationFacade;
    private MonitoringInfo monitoringInfo;

    @Override
    public void apply(ApplicationFacade applicationFacade) {
        this.applicationFacade = applicationFacade;
        this.configBag = applicationFacade.getConfigBag();
        this.monitoringInfo = this.generateMonitoringInfo();
        applicationFacade.addMonitoringInfo(this.monitoringInfo);
        this.addMonitorInfoToTemplate();
    }

    private MonitoringInfo generateMonitoringInfo() {
        MonitoringDamGenerator monDamGen = new MonitoringDamGenerator(this.configBag.getMonitorEndpoint(), this.configBag.getInfluxDbEndpoint());
        return monDamGen.generateMonitoringInfo(this.applicationFacade.templateToString());
    }

    private void addMonitorInfoToTemplate() {
        String generatedApplicationId = UUID.randomUUID().toString();
        HashMap<String, Object> appGroup = new HashMap<String, Object>();
        appGroup.put("members", Arrays.asList("application"));
        HashMap policy = new HashMap();
        HashMap<String, String> policyProperties = new HashMap<String, String>();
        policyProperties.put("id", generatedApplicationId);
        policyProperties.put("type", SEACLOUDS_MONITORING_RULES_ID_POLICY);
        policy.put(MONITORING_RULES_POLICY_NAME, policyProperties);
        ArrayList policiesList = new ArrayList();
        policiesList.add(policy);
        appGroup.put("policies", policiesList);
        this.applicationFacade.addGroup(MONITOR_INFO_GROUPNAME, appGroup);
    }
}

