/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.decorators;

import com.google.common.collect.ImmutableList;
import eu.seaclouds.monitor.monitoringdamgenerator.MonitoringInfo;
import eu.seaclouds.platform.planner.core.DamGeneratorConfigBag;
import eu.seaclouds.platform.planner.core.application.ApplicationFacade;
import eu.seaclouds.platform.planner.core.application.agreements.AgreementGenerator;
import eu.seaclouds.platform.planner.core.application.decorators.ApplicationFacadeDecorator;
import it.polimi.tower4clouds.rules.MonitoringRules;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaCloudsManagementPolicyDecorator
implements ApplicationFacadeDecorator {
    static Logger log = LoggerFactory.getLogger(SeaCloudsManagementPolicyDecorator.class);
    public static final String SLA_ENDPOINT = "slaEndpoint";
    public static final String SLA_AGREEMENT = "slaAgreement";
    public static final String T4C_ENDPOINT = "t4cEndpoint";
    public static final String T4C_RULES = "t4cRules";
    public static final String INFLUXDB_ENDPOINT = "influxdbEndpoint";
    public static final String INFLUXDB_DATABASE = "influxdbDatabase";
    public static final String INFLUXDB_USERNAME = "influxdbUsername";
    public static final String INFLUXDB_PASSWORD = "influxdbPassword";
    public static final String GRAFANA_ENDPOINT = "grafanaEndpoint";
    public static final String GRAFANA_USERNAME = "grafanaUsername";
    public static final String GRAFANA_PASSWORD = "grafanaPassword";
    public static final String SEACLOUDS_APPLICATION_CONFIGURATION_POLICY = "configuration";
    public static final String SEACLOUDS_MANAGEMENT_POLICY = "eu.seaclouds.policy.SeaCloudsManagementPolicy";
    private ApplicationFacade applicationFacade;
    private DamGeneratorConfigBag configBag;
    private AgreementGenerator agreementGenerator;

    @Override
    public void apply(ApplicationFacade applicationFacade) {
        this.applicationFacade = applicationFacade;
        this.configBag = applicationFacade.getConfigBag();
        this.agreementGenerator = applicationFacade.getAgreementGenerator();
        this.addSeaCloudsManagementGroup();
    }

    private void addSeaCloudsManagementGroup() {
        Map<String, Object> policyGroupValue = this.getPolicyGroupValues(this.applicationFacade.getMonitoringInfo(), this.applicationFacade.getApplicationSlaId());
        this.applicationFacade.addGroup("seaclouds_configuration_policy", policyGroupValue);
    }

    public Map<String, Object> getPolicyGroupValues(MonitoringInfo monitoringInfo, String applicationMonitorId) {
        MutableMap seaCloudsPolicyConfiguration = MutableMap.of();
        seaCloudsPolicyConfiguration.put("type", SEACLOUDS_MANAGEMENT_POLICY);
        seaCloudsPolicyConfiguration.put(SLA_ENDPOINT, this.configBag.getSlaEndpoint());
        seaCloudsPolicyConfiguration.put(SLA_AGREEMENT, this.encodeAgreement(applicationMonitorId));
        seaCloudsPolicyConfiguration.put(T4C_ENDPOINT, this.configBag.getMonitorEndpoint().toString());
        seaCloudsPolicyConfiguration.put(T4C_RULES, SeaCloudsManagementPolicyDecorator.encodeBase64MonitoringRules(monitoringInfo));
        seaCloudsPolicyConfiguration.put(INFLUXDB_ENDPOINT, this.configBag.getInfluxDbEndpoint().toString());
        seaCloudsPolicyConfiguration.put(INFLUXDB_DATABASE, this.configBag.getInfluxdbDatabase());
        seaCloudsPolicyConfiguration.put(INFLUXDB_USERNAME, this.configBag.getInfluxdbUsername());
        seaCloudsPolicyConfiguration.put(INFLUXDB_PASSWORD, this.configBag.getInfluxdbPassword());
        seaCloudsPolicyConfiguration.put(GRAFANA_ENDPOINT, this.configBag.getGrafanaEndpoint());
        seaCloudsPolicyConfiguration.put(GRAFANA_USERNAME, this.configBag.getGrafanaUsername());
        seaCloudsPolicyConfiguration.put(GRAFANA_PASSWORD, this.configBag.getGrafanaPassword());
        MutableMap seaCloudsPolicy = MutableMap.of();
        seaCloudsPolicy.put(SEACLOUDS_APPLICATION_CONFIGURATION_POLICY, seaCloudsPolicyConfiguration);
        MutableMap seaCloudsApplicationGroup = MutableMap.of();
        seaCloudsApplicationGroup.put("members", ImmutableList.of());
        seaCloudsApplicationGroup.put("policies", ImmutableList.of((Object)seaCloudsPolicy));
        return seaCloudsApplicationGroup;
    }

    private String encodeAgreement(String applicationMonitorId) {
        String agreement = this.agreementGenerator.getAgreement(applicationMonitorId);
        return Base64.encodeBase64String((byte[])agreement.getBytes());
    }

    private static String encodeBase64MonitoringRules(MonitoringInfo monitoringInfo) {
        StringWriter sw = new StringWriter();
        String marshalledMonitoringRules = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MonitoringRules.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            jaxbMarshaller.marshal((Object)monitoringInfo.getApplicationMonitoringRules(), (Writer)sw);
            marshalledMonitoringRules = sw.toString();
        }
        catch (JAXBException e) {
            log.error("Monitoring rules {} can not be marshalled by addSeaCloudsPolicy in DamGenerator", (Object)monitoringInfo.getApplicationMonitoringRules());
        }
        String encodeMonitoringRules = Base64.encodeBase64String((byte[])marshalledMonitoringRules.getBytes());
        return encodeMonitoringRules;
    }
}

