/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.decorators;

import eu.seaclouds.platform.planner.core.application.ApplicationFacade;
import eu.seaclouds.platform.planner.core.application.agreements.AgreementGenerator;
import eu.seaclouds.platform.planner.core.application.decorators.ApplicationFacadeDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SlaInformationDecorator
implements ApplicationFacadeDecorator {
    public static final String SLA_INFO_GROUPNAME = "sla_gen_info";
    public static final String SEACLOUDS_APPLICATION_INFORMATION_POLICY_TYPE = "seaclouds.policies.app.information";
    public static final String SEACLOUDS_APPLICATION_POLICY_NAME = "seaclouds.app.information";
    private ApplicationFacade applicationFacade;
    private AgreementGenerator agreementGenerator;

    @Override
    public void apply(ApplicationFacade applicationFacade) {
        this.applicationFacade = applicationFacade;
        this.agreementGenerator = applicationFacade.getAgreementGenerator();
        String agreementId = this.agreementGenerator.generateAgreeemntId(applicationFacade.templateToString());
        applicationFacade.addSlaInformation(agreementId);
        this.addApplicationInfo(agreementId);
    }

    public void addApplicationInfo(String applicationInfoId) {
        HashMap<String, Object> appGroup = new HashMap<String, Object>();
        appGroup.put("members", Arrays.asList("application"));
        HashMap policy = new HashMap();
        HashMap<String, String> policyProperties = new HashMap<String, String>();
        policyProperties.put("id", applicationInfoId);
        policyProperties.put("type", SEACLOUDS_APPLICATION_INFORMATION_POLICY_TYPE);
        policy.put(SEACLOUDS_APPLICATION_POLICY_NAME, policyProperties);
        ArrayList policiesList = new ArrayList();
        policiesList.add(policy);
        appGroup.put("policies", policiesList);
        this.applicationFacade.addGroup(SLA_INFO_GROUPNAME, appGroup);
    }
}

