/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology;

import com.google.common.base.Preconditions;
import eu.seaclouds.platform.planner.core.application.topology.modifier.relation.TopologyModifierApplication;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.AbstractNodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplateFactory;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.HostNodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.PaasNodeTemplateFacade;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.PlatformNodeTemplate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;

public class TopologyTemplateFacade {
    private final Map<String, Object> originalAdp;
    private Map<String, Object> topologyTemplate;
    private Map<String, NodeTemplate> nodeTemplates;
    private Map<String, HostNodeTemplate> hostNodeTemplates;
    private Map<String, List<NodeTemplate>> topologyTree;
    private Map<String, Object> originalNodeTemplates;

    public TopologyTemplateFacade(Map<String, Object> adp) {
        this.originalAdp = MutableMap.copyOf(adp);
        this.init();
    }

    private void init() {
        this.initOriginalTopologyTemplate();
        this.initOriginalNodesTemplates();
        this.nodeTemplates = MutableMap.of();
        this.hostNodeTemplates = MutableMap.of();
        this.topologyTree = MutableMap.of();
        this.initNodeTemplates();
    }

    private void initOriginalTopologyTemplate() {
        Preconditions.checkNotNull((Object)this.originalAdp.get("topology_template"), (Object)"TopologyTemplate has to a topology_template element");
        this.topologyTemplate = (Map)this.originalAdp.get("topology_template");
    }

    private void initOriginalNodesTemplates() {
        Preconditions.checkNotNull((Object)this.topologyTemplate.get("node_templates"), (Object)"TopologyTemplate has to contain NodeTemplates");
        this.originalNodeTemplates = (Map)this.topologyTemplate.get("node_templates");
    }

    private void initNodeTemplates() {
        for (String nodeTemplateId : this.originalNodeTemplates.keySet()) {
            NodeTemplate nodeTemplate = NodeTemplateFactory.createNodeTemplate(this.originalAdp, nodeTemplateId);
            this.addNodeTemplate(nodeTemplateId, nodeTemplate);
        }
    }

    private void addNodeTemplate(String nodeTemplateId, NodeTemplate nodeTemplate) {
        this.nodeTemplates.put(nodeTemplateId, nodeTemplate);
        if (nodeTemplate instanceof HostNodeTemplate) {
            this.hostNodeTemplates.put(nodeTemplateId, (HostNodeTemplate)nodeTemplate);
        } else {
            String hostNodeTemplateName = nodeTemplate.getHostNodeName();
            if (!this.topologyTree.containsKey(hostNodeTemplateName)) {
                this.topologyTree.put(hostNodeTemplateName, (List<NodeTemplate>)MutableList.of());
            }
            this.topologyTree.get(hostNodeTemplateName).add(nodeTemplate);
        }
    }

    public Map<String, Object> getRequiredNodeTypes() {
        MutableMap usedNodeTypes = MutableMap.of();
        for (Map.Entry<String, NodeTemplate> nodeTemplateEntry : this.nodeTemplates.entrySet()) {
            NodeTemplate nodeTemplate = nodeTemplateEntry.getValue();
            Map<String, Object> nodeType = nodeTemplate.getNodeTypeDefinition();
            if (nodeType == null) continue;
            usedNodeTypes.put(nodeTemplate.getType(), nodeTemplate.getNodeTypeDefinition());
        }
        return usedNodeTypes;
    }

    public Map<String, Object> getNodeTransformedNodeTemplates() {
        MutableMap transformedNodeTemplates = MutableMap.of();
        for (Map.Entry<String, NodeTemplate> nodeTemplateEntry : this.nodeTemplates.entrySet()) {
            transformedNodeTemplates.put(nodeTemplateEntry.getKey(), nodeTemplateEntry.getValue().transform());
        }
        return transformedNodeTemplates;
    }

    public Map<String, Object> getLocationPoliciesGroups() {
        MutableMap policiesGroups = MutableMap.of();
        for (Map.Entry<String, HostNodeTemplate> hostEntry : this.hostNodeTemplates.entrySet()) {
            HostNodeTemplate hostNodeTemplate = hostEntry.getValue();
            policiesGroups.put(hostNodeTemplate.getLocationPolicyGroupName(), hostNodeTemplate.getLocationPolicyGroupValues());
        }
        return policiesGroups;
    }

    public void updateNoExistNodeTemplate(Map<String, Object> adp) {
        this.topologyTemplate = (Map)adp.get("topology_template");
        this.originalNodeTemplates = (Map)this.topologyTemplate.get("node_templates");
        for (Map.Entry<String, Object> newNodeTemplate : this.originalNodeTemplates.entrySet()) {
            String nodeTemplateId = newNodeTemplate.getKey();
            if (this.contained(newNodeTemplate.getKey())) continue;
            NodeTemplate nodeTemplate = NodeTemplateFactory.createNodeTemplate(adp, nodeTemplateId);
            this.addNodeTemplate(nodeTemplateId, nodeTemplate);
        }
    }

    public void applyModifierApplicator(TopologyModifierApplication applicator) {
        for (Map.Entry<String, NodeTemplate> nodeTemplateEntry : this.nodeTemplates.entrySet()) {
            applicator.applyModifiers(nodeTemplateEntry.getValue(), this);
        }
    }

    public void joinPlatformNodeTemplates() {
        Map<HostNodeTemplate, List<NodeTemplate>> platformAndChildren = this.extractPlatformTemplatesAndChildren();
        this.removeHostAndHostedChildren(platformAndChildren.keySet());
        this.addGeneratedPaasFacades(this.generatedPaasFacades(platformAndChildren));
    }

    private void addGeneratedPaasFacades(List<PaasNodeTemplateFacade> paasNodeTemplateFacades) {
        for (PaasNodeTemplateFacade paasFacade : paasNodeTemplateFacades) {
            this.addNodeTemplate(paasFacade.getNodeTemplateId(), paasFacade);
        }
    }

    private Map<HostNodeTemplate, List<NodeTemplate>> extractPlatformTemplatesAndChildren() {
        MutableMap extracted = MutableMap.of();
        for (Map.Entry<String, HostNodeTemplate> hostEntry : this.hostNodeTemplates.entrySet()) {
            HostNodeTemplate hostNodeTemplate = hostEntry.getValue();
            if (!(hostNodeTemplate instanceof PlatformNodeTemplate)) continue;
            extracted.put(hostNodeTemplate, this.getHostedChildren(hostNodeTemplate));
        }
        return extracted;
    }

    private void removeHostAndHostedChildren(Set<HostNodeTemplate> hostNodeteTemplates) {
        for (HostNodeTemplate hostNodeTemplate : hostNodeteTemplates) {
            List<NodeTemplate> hostedNodeTemplates = this.topologyTree.get(hostNodeTemplate.getNodeTemplateId());
            this.nodeTemplates.remove(hostNodeTemplate.getNodeTemplateId());
            this.hostNodeTemplates.remove(hostNodeTemplate.getNodeTemplateId());
            this.topologyTree.remove(hostNodeTemplate.getNodeTemplateId());
            this.removeHostedNodeTemplates(hostedNodeTemplates);
        }
    }

    private void removeHostedNodeTemplates(List<NodeTemplate> hostedNodeTemplates) {
        for (NodeTemplate hostedNodeTemplate : hostedNodeTemplates) {
            this.nodeTemplates.remove(hostedNodeTemplate.getNodeTemplateId());
        }
    }

    private List<NodeTemplate> getHostedChildren(HostNodeTemplate host) {
        return this.topologyTree.get(host.getNodeTemplateId());
    }

    private List<PaasNodeTemplateFacade> generatedPaasFacades(Map<HostNodeTemplate, List<NodeTemplate>> hostAndChildren) {
        MutableList paasNodeTemplateFacades = MutableList.of();
        for (Map.Entry<HostNodeTemplate, List<NodeTemplate>> entry : hostAndChildren.entrySet()) {
            paasNodeTemplateFacades.addAll(this.generatePaasFacadesFromAPlatform((PlatformNodeTemplate)entry.getKey(), entry.getValue()));
        }
        return paasNodeTemplateFacades;
    }

    private List<PaasNodeTemplateFacade> generatePaasFacadesFromAPlatform(PlatformNodeTemplate platformNodeTemplate, List<NodeTemplate> childNodeTemplates) {
        MutableList paasNodeTemplateFacades = MutableList.of();
        for (NodeTemplate hostedNode : childNodeTemplates) {
            paasNodeTemplateFacades.add(new PaasNodeTemplateFacade((AbstractNodeTemplate)hostedNode, platformNodeTemplate));
        }
        return paasNodeTemplateFacades;
    }

    private boolean contained(String nodeTemplateId) {
        return this.nodeTemplates.containsKey(nodeTemplateId);
    }

    public Object getPropertyValue(String nodeTemplateId, String propertyName) {
        Preconditions.checkNotNull((Object)this.nodeTemplates.get(nodeTemplateId), (Object)("Error finding property, nodeTemplate " + nodeTemplateId + "not found"));
        return this.nodeTemplates.get(nodeTemplateId).getPropertyValue(propertyName);
    }

    public String getNodeTypeOf(String nodeTemplateId) {
        Preconditions.checkNotNull((Object)this.nodeTemplates.get(nodeTemplateId), (Object)("Error finding nodeTemplate type, " + nodeTemplateId + "not found"));
        return this.nodeTemplates.get(nodeTemplateId).getType();
    }

    public Map<String, NodeTemplate> getNodeTemplates() {
        return this.nodeTemplates;
    }

    public boolean isDeployedOnIaaS(String nodeId) {
        return this.nodeTemplates.containsKey(nodeId) && this.nodeTemplates.get(nodeId).isDeployedOnIaaS();
    }

    public boolean isDeployedOnPaaS(String nodeId) {
        return !this.isDeployedOnIaaS(nodeId);
    }
}

