/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.modifier.relation;

import com.google.common.collect.ImmutableList;
import eu.seaclouds.platform.planner.core.application.topology.modifier.relation.AbstractRelationModifier;
import eu.seaclouds.platform.planner.core.application.topology.modifier.relation.PhpUriStringBuilder;
import java.util.List;
import java.util.Map;

public abstract class AbstractPhpDatabaseRelationModifier
extends AbstractRelationModifier {
    public static final String SUPPORTED_RELATIONS = "seaclouds.relations.databaseconnections.php";
    public static final List<String> VALID_TARGET_NODES_TYPES = ImmutableList.of((Object)"org.apache.brooklyn.entity.database.mysql.MySqlNode");
    private static final String DB_NAME_PROPERTY_NAME = "db_name";
    private static final String DB_USER_PROPERTY_NAME = "db_user";
    private static final String DB_PASSWORD_PROPERTY_NAME = "db_password";

    @Override
    protected List<String> getSupportedRelationTypes() {
        return ImmutableList.of((Object)SUPPORTED_RELATIONS);
    }

    @Override
    protected boolean isValidTargetNode(Map<String, Object> requirement) {
        return VALID_TARGET_NODES_TYPES.contains(this.getNodeTargetType(requirement));
    }

    @Override
    protected String getPropValue(Map<String, Object> requirement) {
        return this.createPropertyValue(requirement);
    }

    @Override
    protected String getPropName(Map<String, Object> requirement) {
        Map properties = (Map)this.getRequirementValues(requirement).get("properties");
        return (String)properties.get("prop.name");
    }

    @Override
    protected String getRelationName() {
        return "dbConnection";
    }

    private String createPropertyValue(Map<String, Object> requirement) {
        String targetId = this.getTargetNodeId(requirement);
        String dbName = (String)this.topologyTemplate.getPropertyValue(targetId, DB_NAME_PROPERTY_NAME);
        String dbUSer = (String)this.topologyTemplate.getPropertyValue(targetId, DB_USER_PROPERTY_NAME);
        String dbPass = (String)this.topologyTemplate.getPropertyValue(targetId, DB_PASSWORD_PROPERTY_NAME);
        return PhpUriStringBuilder.buildConnectionString(targetId, dbName, dbUSer, dbPass);
    }
}

