/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.modifier.relation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import eu.seaclouds.platform.planner.core.application.topology.TopologyTemplateFacade;
import eu.seaclouds.platform.planner.core.application.topology.modifier.relation.TopologyTemplateModifier;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplate;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;

public abstract class AbstractRelationModifier
implements TopologyTemplateModifier {
    public static final String NODE = "node";
    public static final String RELATIONSHIP = "relationship";
    public static final String PROP_COLLECTION = "prop.collection";
    public static final String PROP_NAME = "prop.name";
    public static final String PROP_VALUE = "prop.value";
    public static final String RELATION_CONFIGURE = "brooklyn.relationships.Configure";
    protected TopologyTemplateFacade topologyTemplate;
    protected NodeTemplate nodeTemplate;

    @Override
    public void apply(NodeTemplate nodeTemplate, TopologyTemplateFacade topologyTemplateFacade) {
        this.topologyTemplate = topologyTemplateFacade;
        this.nodeTemplate = nodeTemplate;
        if (this.nodeTemplateCanBeModified(nodeTemplate)) {
            this.applyTransformation(nodeTemplate, topologyTemplateFacade);
        }
    }

    protected void applyTransformation(NodeTemplate nodeTemplate, TopologyTemplateFacade topologyTemplateFacade) {
        List<Map<String, Object>> requirements = this.findTargetRelations(nodeTemplate);
        List<Map<String, Object>> transformedRequirements = this.transformRequirements(requirements);
        this.deleteRequirements(nodeTemplate, requirements);
        nodeTemplate.getRequirements().addAll(transformedRequirements);
    }

    protected List<Map<String, Object>> transformRequirements(List<Map<String, Object>> requirements) {
        MutableList transformedRequirements = MutableList.of();
        for (Map<String, Object> requirement : requirements) {
            transformedRequirements.add(this.transformRequirement(requirement));
        }
        return transformedRequirements;
    }

    protected Map<String, Object> transformRequirement(Map<String, Object> requirement) {
        MutableMap transformedRequirement = MutableMap.of();
        transformedRequirement.put(this.getRelationName(), this.getTransformRequirementValues(requirement));
        return transformedRequirement;
    }

    protected Map<String, Object> getTransformRequirementValues(Map<String, Object> requirement) {
        MutableMap transformedRequirementValues = MutableMap.of();
        transformedRequirementValues.put(NODE, this.getTargetNodeId(requirement));
        transformedRequirementValues.put(RELATIONSHIP, RELATION_CONFIGURE);
        transformedRequirementValues.put("properties", this.getRelationPropertiesValues(requirement));
        return transformedRequirementValues;
    }

    protected Map<String, Object> getRelationPropertiesValues(Map<String, Object> requirement) {
        MutableMap properties = MutableMap.of();
        properties.put(PROP_COLLECTION, this.getPropCollection(requirement));
        properties.put(PROP_NAME, this.getPropName(requirement));
        properties.put(PROP_VALUE, this.getPropValue(requirement));
        return properties;
    }

    protected final String getNodeTargetType(Map<String, Object> requirement) {
        return this.topologyTemplate.getNodeTypeOf(this.getTargetNodeId(requirement));
    }

    protected List<Map<String, Object>> findTargetRelations(NodeTemplate nodeTemplate) {
        List<Map<String, Object>> requirements = nodeTemplate.getRequirements();
        MutableList foundRelations = MutableList.of();
        for (Map<String, Object> requirement : requirements) {
            if (!this.canBeTransformed(requirement)) continue;
            foundRelations.add(requirement);
        }
        return foundRelations;
    }

    private boolean canBeTransformed(Map<String, Object> requirement) {
        return !this.isHostRequirement(requirement) && this.isSupportedRelation(requirement) && this.isValidTargetNode(requirement);
    }

    private boolean isSupportedRelation(Map<String, Object> requirement) {
        return this.getSupportedRelationTypes().contains(this.getRequirmentType(requirement));
    }

    private void deleteRequirements(NodeTemplate nodeTemplate, List<Map<String, Object>> requirements) {
        for (Map<String, Object> requirement : requirements) {
            nodeTemplate.getRequirements().remove(requirement);
        }
    }

    private boolean isHostRequirement(Map<String, Object> requirement) {
        return requirement.containsKey("host");
    }

    protected Map<String, Object> getRequirementValues(Map<String, Object> requirement) {
        if (this.isHostRequirement(requirement)) {
            return requirement;
        }
        return (Map)requirement.get(this.getRequirementId(requirement));
    }

    private String getRequirementId(Map<String, Object> requirement) {
        if (requirement.containsKey("host")) {
            return (String)requirement.get("host");
        }
        return this.getNotHostRequirement(requirement);
    }

    private String getNotHostRequirement(Map<String, Object> requirement) {
        Preconditions.checkState((requirement.size() == 1 ? 1 : 0) != 0, (Object)"Not valid Requirement, too properties for non-Host requirement. Expected a map with just an entry");
        return (String)Iterators.getOnlyElement(requirement.keySet().iterator());
    }

    protected String getTargetNodeId(Map<String, Object> requirement) {
        return (String)this.getRequirementValues(requirement).get(NODE);
    }

    private String getRequirmentType(Map<String, Object> requirement) {
        return (String)this.getRequirementValues(requirement).get("type");
    }

    protected abstract boolean nodeTemplateCanBeModified(NodeTemplate var1);

    protected abstract List<String> getSupportedRelationTypes();

    protected abstract boolean isValidTargetNode(Map<String, Object> var1);

    protected abstract String getPropValue(Map<String, Object> var1);

    protected abstract String getPropName(Map<String, Object> var1);

    protected abstract String getPropCollection(Map<String, Object> var1);

    protected abstract String getRelationName();
}

