/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.nodetemplate;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.ComputeNodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.modifiers.JavaPaasArtifactsModifier;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.modifiers.PhpPaasArtifactsModifier;
import eu.seaclouds.platform.planner.core.resolver.DeployerTypesResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNodeTemplate
implements NodeTemplate {
    static Logger log = LoggerFactory.getLogger(AbstractNodeTemplate.class);
    private static final String REQUIREMENTS = "requirements";
    private static final String INSTANCES_POC = "instancesPOC";
    private static final String HOST = "host";
    private static final String ARTIFACTS = "artifacts";
    private static final String PROPERTIES = "properties";
    private static final String NODE_TYPES = "node_types";
    private static final String TOPOLOGY_TEMPLATE = "topology_template";
    private static final String NODE_TEMPLATES = "node_templates";
    private static final String DERIVED_FROM = "derived_from";
    public static final String BROOKLYN_IAAS_TYPES_MAPPING = "mapping/brooklyn-iaas-types-mapping.yaml";
    public static final String BROOKLYN_PAAS_TYPES_MAPPING = "mapping/brooklyn-paas-types-mapping.yaml";
    protected final String nodeTemplateId;
    protected Map<String, Object> module;
    private final Map<String, Object> applicationTemplate;
    private List<Map<String, Object>> requirements;
    private List<Map<String, Object>> artifacts;
    private Map<String, Object> nodeTypes;
    private DeployerTypesResolver deployerTypesResolver;
    private Map<String, Object> properties;
    private Map<String, Object> topologyTemplate;
    private Map<String, Object> nodeTemplates;

    public AbstractNodeTemplate(Map<String, Object> applicationTemplate, String nodeTemplateId) {
        this.applicationTemplate = applicationTemplate;
        this.nodeTemplateId = nodeTemplateId;
        this.init();
        this.customize();
    }

    @Override
    public Map<String, Object> transform() {
        MutableMap nodeTemplate = MutableMap.of();
        if (!this.requirements.isEmpty()) {
            nodeTemplate.put(REQUIREMENTS, this.requirements);
        }
        Map<String, Object> transformedProperties = this.addArtifactsAsProperties();
        nodeTemplate.put(PROPERTIES, transformedProperties);
        nodeTemplate.put("type", this.getType());
        return nodeTemplate;
    }

    protected void init() {
        this.topologyTemplate = (Map)this.applicationTemplate.get(TOPOLOGY_TEMPLATE);
        this.nodeTemplates = (Map)this.topologyTemplate.get(NODE_TEMPLATES);
        this.module = (Map)this.nodeTemplates.get(this.nodeTemplateId);
        this.initRequirements();
        this.initArtifacts();
        this.initNodeTypes();
        this.initTypeResolver();
        this.initProperties();
    }

    private void customize() {
        this.customizeRequirements();
        this.applyModifiers();
    }

    private void applyModifiers() {
        PhpPaasArtifactsModifier phpPaasArtifactsModifier = new PhpPaasArtifactsModifier();
        phpPaasArtifactsModifier.apply(this);
        JavaPaasArtifactsModifier javaPaasArtifactsModifier = new JavaPaasArtifactsModifier();
        javaPaasArtifactsModifier.apply(this);
    }

    private void initNodeTypes() {
        this.nodeTypes = (Map)this.applicationTemplate.get(NODE_TYPES);
    }

    private List<Map<String, Object>> initRequirements() {
        this.requirements = MutableList.of();
        if (this.module.containsKey(REQUIREMENTS)) {
            this.requirements = (ArrayList)this.module.get(REQUIREMENTS);
        }
        return this.requirements;
    }

    private List<Map<String, Object>> initArtifacts() {
        this.artifacts = ImmutableList.of();
        if (this.module.containsKey(ARTIFACTS)) {
            this.artifacts = (ArrayList)this.module.get(ARTIFACTS);
        }
        return this.artifacts;
    }

    private Map<String, Object> initProperties() {
        this.properties = MutableMap.of();
        if (this.module.containsKey(PROPERTIES)) {
            this.properties = (Map)this.module.get(PROPERTIES);
        }
        return this.properties;
    }

    public List<Map<String, Object>> customizeRequirements() {
        for (Map<String, Object> requirement : this.requirements) {
            this.cleanInstancesPocEntry(requirement);
        }
        return this.requirements;
    }

    private void cleanInstancesPocEntry(Map<String, Object> requirement) {
        if (requirement.containsKey(INSTANCES_POC)) {
            requirement.remove(INSTANCES_POC);
        }
    }

    private Map<String, Object> getHostRequirement() {
        for (Map<String, Object> req : this.requirements) {
            if (!req.containsKey(HOST)) continue;
            return req;
        }
        return null;
    }

    public void deleteHostRequirement() {
        this.requirements.remove(this.getHostRequirement());
    }

    @Override
    public String getHostNodeName() {
        String result = null;
        Map<String, Object> hostRequirement = this.getHostRequirement();
        if (hostRequirement != null) {
            result = (String)hostRequirement.get(HOST);
        }
        return result;
    }

    private Map<String, Object> getNodeTemplates() {
        return (Map)this.getTopologyTemplate().get(NODE_TEMPLATES);
    }

    private Map<String, Object> getTopologyTemplate() {
        return (Map)this.applicationTemplate.get(TOPOLOGY_TEMPLATE);
    }

    private Map<String, Object> getHostTemplate() {
        return (Map)this.getNodeTemplates().get(this.getHostNodeName());
    }

    private Map<String, Object> addArtifactsAsProperties() {
        if (!this.artifacts.isEmpty()) {
            for (Map<String, Object> artifact : this.artifacts) {
                artifact.remove("type");
                Set<String> artifactKeys = artifact.keySet();
                if (artifactKeys.size() > 1) {
                    log.error("Artifact element was not found in {}", this.module);
                    throw new IllegalArgumentException("Malformed artifact. Item was not found");
                }
                String[] keys = artifactKeys.toArray(new String[1]);
                this.setPropertyToNodeTemplate(keys[0], artifact.get(keys[0]));
            }
        }
        return this.getProperties();
    }

    private void setPropertyToNodeTemplate(String propertyName, Object propertyValue) {
        this.getProperties().put(propertyName, propertyValue);
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    private String getParentType() {
        String moduleType = this.getModuleType();
        if (this.nodeTypes.containsKey(moduleType)) {
            HashMap type = (HashMap)this.nodeTypes.get(moduleType);
            return (String)type.get(DERIVED_FROM);
        }
        return moduleType;
    }

    @Override
    public String getType() {
        return this.deployerTypesResolver.resolveNodeType(this.getParentType());
    }

    @Override
    public String getModuleType() {
        return (String)this.module.get("type");
    }

    private void initTypeResolver() {
        if (this.isDeployedOnIaaS()) {
            this.getDeployerIaaSTypeResolver();
        } else {
            this.getDeployerPaaSTypeResolver();
        }
    }

    @Override
    public boolean isDeployedOnIaaS() {
        return this.isAnIaasType(this.getModuleType()) || this.hostDeployedOnIaaS();
    }

    private boolean isAnIaasType(String type) {
        return ComputeNodeTemplate.isSupported(type);
    }

    private boolean hostDeployedOnIaaS() {
        String hostName = this.getHostNodeName();
        if (hostName != null) {
            String type = (String)this.getHostTemplate().get("type");
            return this.isAnIaasType(type);
        }
        return false;
    }

    public void getDeployerIaaSTypeResolver() {
        try {
            if (this.deployerTypesResolver == null) {
                this.deployerTypesResolver = new DeployerTypesResolver(Resources.getResource((String)BROOKLYN_IAAS_TYPES_MAPPING).toURI().toString());
            }
        }
        catch (Exception e) {
            log.error("TypeResolver can not be build fof IaaS");
            throw new RuntimeException(e);
        }
    }

    public void getDeployerPaaSTypeResolver() {
        try {
            if (this.deployerTypesResolver == null) {
                this.deployerTypesResolver = new DeployerTypesResolver(Resources.getResource((String)BROOKLYN_PAAS_TYPES_MAPPING).toURI().toString());
            }
        }
        catch (Exception e) {
            log.error("TypeResolver can not be build fof PaaS");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> getNodeTypeDefinition() {
        return (Map)this.deployerTypesResolver.getNodeTypeDefinition(this.getType());
    }

    protected DeployerTypesResolver getDeployerTypesResolver() {
        return this.deployerTypesResolver;
    }

    @Override
    public List<Map<String, Object>> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public List<Map<String, Object>> getRequirements() {
        return this.requirements;
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public String getNodeTemplateId() {
        return this.nodeTemplateId;
    }
}

