/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.nodetemplate;

import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.AbstractNodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.datacollectors.Datacollector;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.ComputeNodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.PlatformNodeTemplate;
import java.util.Map;

public class NodeTemplateFactory {
    public static NodeTemplate createNodeTemplate(Map<String, Object> applicationTemplate, String nodeTemplateId) {
        Map topologyTemplate = (Map)applicationTemplate.get("topology_template");
        Map nodeTemplates = (Map)topologyTemplate.get("node_templates");
        Map module = (Map)nodeTemplates.get(nodeTemplateId);
        String moduleType = (String)module.get("type");
        if (ComputeNodeTemplate.isSupported(moduleType)) {
            return new ComputeNodeTemplate(applicationTemplate, nodeTemplateId);
        }
        if (PlatformNodeTemplate.isSupported(moduleType)) {
            return new PlatformNodeTemplate(applicationTemplate, nodeTemplateId);
        }
        if (Datacollector.isSupported(moduleType)) {
            return new Datacollector(applicationTemplate, nodeTemplateId);
        }
        return new AbstractNodeTemplate(applicationTemplate, nodeTemplateId);
    }
}

