/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host;

import com.google.common.collect.ImmutableList;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.AbstractHostNodeTemplate;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;

public class ComputeNodeTemplate
extends AbstractHostNodeTemplate {
    public static final String JCLOUDS = "jclouds";
    public static final String LOCATION = "location";
    public static final String REGION = "region";
    public static final String HARDWARE_ID = "hardwareId";
    public static final String ID_PROP_NAME = "identity";
    public static final String ID_PROP_DAFAULT_VALUE = "<id>";
    public static final String CREDENTIAL_PROP_NAME = "credential";
    public static final String CREDENTIAL_PROP_DEFAULT_VALUE = "<key>";
    private static final List<String> SUPPORTED_TYPES = ImmutableList.of((Object)"tosca.nodes.Compute", (Object)"seaclouds.nodes.Compute");

    public ComputeNodeTemplate(Map<String, Object> applicationTemplate, String nodeTemplateId) {
        super(applicationTemplate, nodeTemplateId);
    }

    public static boolean isSupported(String type) {
        return SUPPORTED_TYPES.contains(type);
    }

    @Override
    public String getType() {
        return this.getDeployerTypesResolver().resolveNodeType(this.getModuleType());
    }

    @Override
    public Map<String, Object> getLocationPolicyProperties() {
        return this.createLocationPolicy();
    }

    private Map<String, Object> createLocationPolicy() {
        MutableMap locationPolicyDescription = MutableMap.of();
        locationPolicyDescription.put("brooklyn.location", this.createLocationDescription());
        return locationPolicyDescription;
    }

    private Map<String, Object> createLocationDescription() {
        MutableMap locationDescription = MutableMap.of();
        Map<String, Object> properties = this.getProperties();
        String location = (String)properties.get(LOCATION);
        locationDescription.put("jclouds:" + location, this.createLocationConfigration());
        return locationDescription;
    }

    private Map<String, Object> createLocationConfigration() {
        MutableMap locationProperties = MutableMap.of();
        Map<String, Object> properties = this.getProperties();
        String region = (String)properties.get(REGION);
        String hardwareId = (String)properties.get(HARDWARE_ID);
        locationProperties.put(REGION, region);
        locationProperties.put(HARDWARE_ID, hardwareId);
        locationProperties.put(ID_PROP_NAME, ID_PROP_DAFAULT_VALUE);
        locationProperties.put(CREDENTIAL_PROP_NAME, CREDENTIAL_PROP_DEFAULT_VALUE);
        return locationProperties;
    }

    protected Map<String, Object> createSimpleLocationPolicy() {
        MutableMap locationPolicyDescription = MutableMap.of();
        Map<String, Object> properties = this.getProperties();
        String location = (String)properties.get(LOCATION);
        String region = (String)properties.get(REGION);
        locationPolicyDescription.put("brooklyn.location", location + ":" + region);
        return locationPolicyDescription;
    }
}

