/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host;

import com.google.common.collect.ImmutableList;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.host.AbstractHostNodeTemplate;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;

public class PlatformNodeTemplate
extends AbstractHostNodeTemplate {
    private static final List<String> SUPPORTED_TYPES = ImmutableList.of((Object)"seaclouds.nodes.Platform.Cloud_Foundry");
    private static final String CLOUDFOUNDRY = "cloudfoundry";
    private static final String USER_PROP_NAME = "user";
    private static final String USER_PROP_DEFAULT_VALUE = "<AKA_YOUR_USER_EMAIL>";
    private static final String PASSWORD_PROP_NAME = "password";
    private static final String PASSWORD_PROP_DEFAULT_VALUE = "<password>";
    private static final String ORG_PROP_NAME = "org";
    private static final String ORG_PROP_DEFAULT_VALUE = "<organization>";
    private static final String ENDPOINT_PROP_NAME = "endpoint";
    private static final String ENDPOINT_PROP_DEFAULT_VALUE = "<API_endpoint>";
    private static final String SPACE_PROP_NAME = "space";
    private static final String SPACE_PROP_DEFAULT_VALUE = "<space>";
    private static final String ADDRESS_PROP_NAME = "address";
    private static final String ADDRESS_PROP_DEFAULT_VALUE = "<platform_address>";

    public PlatformNodeTemplate(Map<String, Object> applicationTemplate, String nodeTemplateId) {
        super(applicationTemplate, nodeTemplateId);
    }

    public static boolean isSupported(String type) {
        return SUPPORTED_TYPES.contains(type);
    }

    @Override
    public String getType() {
        return this.getModuleType();
    }

    @Override
    public Map<String, Object> getLocationPolicyProperties() {
        return this.createLocationPolicy();
    }

    private Map<String, Object> createLocationPolicy() {
        MutableMap locationPolicyDescription = MutableMap.of();
        locationPolicyDescription.put("brooklyn.location", this.createLocationDescription());
        return locationPolicyDescription;
    }

    private Map<String, Object> createLocationDescription() {
        MutableMap locationDescription = MutableMap.of();
        locationDescription.put(CLOUDFOUNDRY, this.createLocationConfigration());
        return locationDescription;
    }

    private Map<String, Object> createLocationConfigration() {
        MutableMap locationConfiguration = MutableMap.of();
        locationConfiguration.put(USER_PROP_NAME, USER_PROP_DEFAULT_VALUE);
        locationConfiguration.put(PASSWORD_PROP_NAME, PASSWORD_PROP_DEFAULT_VALUE);
        locationConfiguration.put(ORG_PROP_NAME, ORG_PROP_DEFAULT_VALUE);
        locationConfiguration.put(ENDPOINT_PROP_NAME, ENDPOINT_PROP_DEFAULT_VALUE);
        locationConfiguration.put(SPACE_PROP_NAME, SPACE_PROP_DEFAULT_VALUE);
        locationConfiguration.put(ADDRESS_PROP_NAME, ADDRESS_PROP_DEFAULT_VALUE);
        return locationConfiguration;
    }

    private Map<String, Object> createSimpleLocationPolicy() {
        MutableMap locationPolicyDescription = MutableMap.of();
        locationPolicyDescription.put("brooklyn.location", "cloudfoundry-instance");
        return locationPolicyDescription;
    }
}

