/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.nodetemplate.modifiers;

import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.modifiers.NodeTemplateFacadeModifier;
import java.util.List;
import java.util.Map;

public class JavaPaasArtifactsModifier
implements NodeTemplateFacadeModifier {
    private static final String TARGET_TYPE = "org.apache.brooklyn.entity.cloudfoundry.webapp.java.JavaCloudFoundryPaasWebApp";
    private static final String WARS_ROOT_ARTIFACT = "wars.root";
    private static final String APPLICATION_URL_ARTIFACT = "application-url";

    private boolean isApplicable(NodeTemplate nodeTemplate) {
        return !nodeTemplate.isDeployedOnIaaS() && nodeTemplate.getType().equals(TARGET_TYPE);
    }

    @Override
    public void apply(NodeTemplate nodeTemplate) {
        if (this.isApplicable(nodeTemplate)) {
            this.modifyTargetArtifactProperty(nodeTemplate);
        }
    }

    private void modifyTargetArtifactProperty(NodeTemplate nodeTemplate) {
        List<Map<String, Object>> artifacts = nodeTemplate.getArtifacts();
        for (Map<String, Object> artifact : artifacts) {
            this.modifyWarsRootArtifact(artifact);
        }
    }

    private void modifyWarsRootArtifact(Map<String, Object> artifact) {
        if (artifact.containsKey(WARS_ROOT_ARTIFACT)) {
            String targetUrlArtifact = (String)artifact.get(WARS_ROOT_ARTIFACT);
            artifact.remove(WARS_ROOT_ARTIFACT);
            this.addApplicationUrlArtifact(artifact, targetUrlArtifact);
        }
    }

    private void addApplicationUrlArtifact(Map<String, Object> artifact, String targetUrlArtifac) {
        artifact.put(APPLICATION_URL_ARTIFACT, targetUrlArtifac);
    }
}

