/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.application.topology.nodetemplate.modifiers;

import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.NodeTemplate;
import eu.seaclouds.platform.planner.core.application.topology.nodetemplate.modifiers.NodeTemplateFacadeModifier;
import java.util.List;
import java.util.Map;

public class PhpPaasArtifactsModifier
implements NodeTemplateFacadeModifier {
    private static final String TARGET_TYPE = "org.apache.brooklyn.entity.cloudfoundry.webapp.php.PhpCloudFoundryPaasWebApp";
    private static final String GIT_URL_ARTIFACT = "git.url";
    private static final String TARBALL_URL_ARTIFACT = "tarball.url";
    private static final String APPLICATION_URL_ARTIFACT = "application-url";

    private boolean isApplicable(NodeTemplate nodeTemplate) {
        return !nodeTemplate.isDeployedOnIaaS() && nodeTemplate.getType().equals(TARGET_TYPE);
    }

    @Override
    public void apply(NodeTemplate nodeTemplate) {
        if (this.isApplicable(nodeTemplate)) {
            this.modifyTargetArtifactProperty(nodeTemplate);
        }
    }

    private void modifyTargetArtifactProperty(NodeTemplate nodeTemplate) {
        List<Map<String, Object>> artifacts = nodeTemplate.getArtifacts();
        for (Map<String, Object> artifact : artifacts) {
            this.modifyGitUrlArtifact(artifact);
            this.modifyTarballUrlArtifact(artifact);
        }
    }

    private void modifyTarballUrlArtifact(Map<String, Object> artifact) {
        if (artifact.containsKey(TARBALL_URL_ARTIFACT)) {
            String targetUrlArtifact = (String)artifact.get(TARBALL_URL_ARTIFACT);
            artifact.remove(TARBALL_URL_ARTIFACT);
            this.addApplicationUrlArtifact(artifact, targetUrlArtifact);
        }
    }

    private void modifyGitUrlArtifact(Map<String, Object> artifact) {
        if (artifact.containsKey(GIT_URL_ARTIFACT)) {
            String targetUrlArtifact = (String)artifact.get(GIT_URL_ARTIFACT);
            artifact.remove(GIT_URL_ARTIFACT);
            this.addApplicationUrlArtifact(artifact, targetUrlArtifact);
        }
    }

    private void addApplicationUrlArtifact(Map<String, Object> artifact, String targetUrlArtifac) {
        artifact.put(APPLICATION_URL_ARTIFACT, targetUrlArtifac);
    }
}

