/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.resolver;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import eu.seaclouds.platform.planner.core.utils.YamlParser;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployerTypesResolver {
    static Logger log = LoggerFactory.getLogger(DeployerTypesResolver.class);
    private static final String NODE_TYPES_MAPPING_SECTION = "mapping.node_types";
    private static final String RELATIONSHIP_TYPES_MAPPING_SECTION = "mapping.relationship_types";
    private static final String POLICY_TYPES_MAPPING_SECTION = "mapping.policy_types";
    private static final String NODE_TYPES_DEFINITIONS = "node_types";
    Map<String, Object> mapping;
    Map<String, String> nodeTypesMapping;
    Map<String, String> relationshipTypesMapping;
    Map<String, String> policyTypesMapping;
    Map<String, Object> nodeTypesDefinitions;

    public DeployerTypesResolver(String mappingFile) throws IOException {
        this(new URL(mappingFile));
    }

    public DeployerTypesResolver(URL mappingFileUrl) throws IOException {
        this.mapping = YamlParser.load(Resources.toString((URL)mappingFileUrl, (Charset)Charsets.UTF_8));
        this.initTypesMapping();
    }

    private void initTypesMapping() {
        if (this.mapping == null) {
            throw new IllegalStateException("Mapping does contain any information in DeployerTypesResolver " + this);
        }
        if (this.mapping.containsKey(NODE_TYPES_MAPPING_SECTION)) {
            log.debug("Mapping contains NodeTypes mapping");
            this.nodeTypesMapping = (Map)this.mapping.get(NODE_TYPES_MAPPING_SECTION);
        }
        if (this.mapping.containsKey(RELATIONSHIP_TYPES_MAPPING_SECTION)) {
            log.debug("Mapping contains NodeTypes mapping");
            this.relationshipTypesMapping = (Map)this.mapping.get(RELATIONSHIP_TYPES_MAPPING_SECTION);
        }
        if (this.mapping.containsKey(NODE_TYPES_DEFINITIONS)) {
            log.debug("Mapping contains NodeTypes description");
            this.nodeTypesDefinitions = (Map)this.mapping.get(NODE_TYPES_DEFINITIONS);
        }
        if (this.mapping.containsKey(POLICY_TYPES_MAPPING_SECTION)) {
            log.debug("Mapping contains Policy mapping");
            this.policyTypesMapping = (Map)this.mapping.get(POLICY_TYPES_MAPPING_SECTION);
        }
    }

    public String resolveNodeType(String sourceNodeType) {
        if (this.nodeTypesMapping == null) {
            log.debug("NodeType mapping was not initialized for " + this);
            return null;
        }
        return this.nodeTypesMapping.get(sourceNodeType);
    }

    public String resolveRelationshipType(String sourceRelationshipType) {
        if (this.relationshipTypesMapping == null) {
            log.debug("RelationshipType mapping was not initialized for " + this);
            return null;
        }
        return this.relationshipTypesMapping.get(sourceRelationshipType);
    }

    public Object getNodeTypeDefinition(String nodeType) {
        if (this.nodeTypesDefinitions == null) {
            log.debug("NodeTypes definitions was not initialized for " + this);
            return null;
        }
        return this.nodeTypesDefinitions.get(nodeType);
    }

    public String resolvePolicyType(String sourcePolicyType) {
        if (this.policyTypesMapping == null) {
            log.debug("Policy mapping was not initialized for " + this);
            return null;
        }
        return this.policyTypesMapping.get(sourcePolicyType);
    }
}

