/*
 * Decompiled with CFR 0.152.
 */
package eu.seaclouds.platform.planner.core.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.seaclouds.planner.matchmaker.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private CloseableHttpClient httpclient = HttpClients.createDefault();
    private String serviceURL;
    private ObjectMapper mapper;
    static Logger log = LoggerFactory.getLogger(HttpHelper.class);

    public HttpHelper(String serviceURL) {
        this.serviceURL = serviceURL;
        this.mapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequest(String restPath, List<NameValuePair> params) {
        log.info("Getting request for " + this.serviceURL + restPath);
        HttpGet httpGet = new HttpGet(this.prepareRequestURL(restPath, params));
        CloseableHttpResponse response = null;
        String content = "";
        try {
            response = this.httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            content = new Scanner(entity.getContent()).useDelimiter("\\Z").next();
            EntityUtils.consume((HttpEntity)entity);
            log.info("Request executed succesfully");
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                log.error("IOEXception", (Throwable)e);
            }
        }
        return content;
    }

    public String postInBody(String restPath, String bodyContent) {
        log.info("Posting request for " + this.serviceURL + restPath);
        HttpPost post = new HttpPost(this.prepareRequestURL(restPath));
        String result = "";
        try {
            StringEntity entity = new StringEntity(bodyContent);
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)post);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            log.error("ClientProtocolException", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, String> postRequest(String restPath, List<NameValuePair> params) {
        log.info("Posting request for " + this.serviceURL + restPath);
        HttpPost httpPost = new HttpPost(this.prepareRequestURL(restPath, new ArrayList<NameValuePair>()));
        CloseableHttpResponse response = null;
        String content = "";
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            int status = response.getStatusLine().getStatusCode();
            content = status == 200 ? EntityUtils.toString((HttpEntity)entity) : response.getStatusLine().getReasonPhrase();
            EntityUtils.consume((HttpEntity)entity);
            log.info("Post success");
            Pair pair = new Pair((Object)String.valueOf(status), (Object)content);
            return pair;
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncodingException", (Throwable)e);
        }
        catch (ClientProtocolException e) {
            log.error("ClientProtocolException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                log.error("IOException", (Throwable)e);
            }
        }
        return new Pair((Object)"500", (Object)("Post Exception for: " + httpPost.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, String> postRequestWithParams(String restPath, List<NameValuePair> params) {
        log.info("Posting request for " + this.serviceURL + restPath);
        HttpPost httpPost = new HttpPost(this.prepareRequestURL(restPath, params));
        CloseableHttpResponse response = null;
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String content = "";
            int status = response.getStatusLine().getStatusCode();
            content = status == 200 ? EntityUtils.toString((HttpEntity)entity) : response.getStatusLine().getReasonPhrase();
            EntityUtils.consume((HttpEntity)entity);
            log.info("Post success");
            Pair pair = new Pair((Object)String.valueOf(status), (Object)content);
            return pair;
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getCause().getMessage(), (Throwable)e);
            Pair pair = new Pair((Object)"500", (Object)("Exception: " + e.getCause().getMessage()));
            return pair;
        }
        catch (ClientProtocolException e) {
            log.error("ClientProtocolException");
            Pair pair = new Pair((Object)"500", (Object)("Exception: " + e.getCause().getMessage()));
            return pair;
        }
        catch (IOException e) {
            log.error("IOException");
            Pair pair = new Pair((Object)"500", (Object)("Exception: " + e.getCause().getMessage()));
            return pair;
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                log.error("IOException", (Throwable)e);
                return new Pair((Object)"500", (Object)("Exception: " + e.getCause().getMessage()));
            }
        }
    }

    private String prepareRequestURL(String restPath) {
        return this.prepareRequestURL(restPath, new ArrayList<NameValuePair>());
    }

    private String prepareRequestURL(String restPath, List<NameValuePair> params) {
        StringBuilder operationBuilder = new StringBuilder();
        operationBuilder.append(this.serviceURL);
        operationBuilder.append(restPath);
        if (params.size() > 0) {
            operationBuilder.append("?");
            URLCodec coded = new URLCodec();
            try {
                for (NameValuePair p : params) {
                    operationBuilder.append(p.getName() + "=" + coded.encode(p.getValue()));
                }
            }
            catch (EncoderException e) {
                log.error(e.getCause().getMessage(), (Throwable)e);
                return "";
            }
        }
        return operationBuilder.toString();
    }
}

