/*
 * Decompiled with CFR 0.152.
 */
package eu.sirotin.kotunil.core;

import eu.sirotin.kotunil.core.Dimensions;
import eu.sirotin.kotunil.core.ExpressionKt;
import eu.sirotin.kotunil.core.Factor;
import eu.sirotin.kotunil.core.UnitPresentation;
import eu.sirotin.kotunil.core.UnitSpecification;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\n\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001d\b\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0007J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u001aJ\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0007J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u001aJ\u0010\u0010$\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0007J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u001aJ\b\u0010%\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020\u0012H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Leu/sirotin/kotunil/core/Expression;", "", "Leu/sirotin/kotunil/core/UnitPresentation;", "value", "", "description", "Leu/sirotin/kotunil/core/UnitSpecification;", "(DLeu/sirotin/kotunil/core/UnitSpecification;)V", "dimensions", "Leu/sirotin/kotunil/core/Dimensions;", "(DLeu/sirotin/kotunil/core/Dimensions;)V", "getDimensions", "()Leu/sirotin/kotunil/core/Dimensions;", "getValue", "()D", "setValue", "(D)V", "categorySymbols", "", "checkCompatibility", "", "other", "compare", "", "compareTo", "div", "", "equals", "", "", "hashCode", "minus", "numberDivOn", "plus", "pw", "degree", "times", "toString", "unitSymbols", "kotunil"})
public class Expression
implements Comparable<Expression>,
UnitPresentation {
    private double value;
    @NotNull
    private final Dimensions dimensions;

    public Expression(double value, @NotNull Dimensions dimensions) {
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        this.value = value;
        this.dimensions = dimensions;
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double d) {
        this.value = d;
    }

    @NotNull
    public final Dimensions getDimensions() {
        return this.dimensions;
    }

    public Expression(double value, @NotNull UnitSpecification<?> description) {
        Intrinsics.checkNotNullParameter(description, (String)"description");
        this(value, new Dimensions(SetsKt.setOf((Object)new Factor(description, 0.0, 2, null))));
    }

    public /* synthetic */ Expression(double d, UnitSpecification unitSpecification, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        this(d, unitSpecification);
    }

    public final int compare(@NotNull Expression other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other);
    }

    @Override
    public int compareTo(@NotNull Expression other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.checkCompatibility(other);
        double d = this.value - other.value;
        double m = Math.max(Math.abs(this.value), Math.abs(other.value));
        if (m == 0.0) {
            return 0;
        }
        if (Math.abs(d) / m < 1.0E-12) {
            return 0;
        }
        return Double.compare(this.value, other.value);
    }

    private final void checkCompatibility(Expression other) {
        if (!Intrinsics.areEqual((Object)this.unitSymbols(), (Object)other.unitSymbols())) {
            throw new IllegalArgumentException("Can't process objects with different dimensions: '" + this.unitSymbols() + "' and " + other.unitSymbols());
        }
    }

    @Override
    @NotNull
    public String unitSymbols() {
        return this.dimensions.unitSymbols();
    }

    @Override
    @NotNull
    public String categorySymbols() {
        return this.dimensions.categorySymbols();
    }

    @NotNull
    public String toString() {
        return "" + this.value + ' ' + this.unitSymbols();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        try {
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type eu.sirotin.kotunil.core.Expression");
            Expression cfr_ignored_0 = (Expression)other;
            if (this.compareTo((Expression)other) == 0) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    public int hashCode() {
        int result = Double.hashCode(this.value);
        result = 31 * result + this.dimensions.hashCode();
        return result;
    }

    @NotNull
    public final Expression plus(@NotNull Expression other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ExpressionKt.plus(this, other);
    }

    @NotNull
    public final Expression minus(@NotNull Expression other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ExpressionKt.minus(this, other);
    }

    @NotNull
    public final Expression times(@NotNull Expression other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ExpressionKt.times(this, other);
    }

    @NotNull
    public final Expression times(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ExpressionKt.times(this, other);
    }

    @NotNull
    public final Expression div(@NotNull Expression other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ExpressionKt.div(this, other);
    }

    @NotNull
    public final Expression div(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ExpressionKt.div(this, other);
    }

    @NotNull
    public final Expression numberDivOn(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ExpressionKt.div(other, this);
    }

    @NotNull
    public final Expression pw(@NotNull Number degree) {
        Intrinsics.checkNotNullParameter((Object)degree, (String)"degree");
        return ExpressionKt.pow(this, degree);
    }
}

