/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.operators;

import eu.stamp_project.mutationtest.descartes.operators.MutationOperator;
import eu.stamp_project.utils.TypeHelper;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;
import org.pitest.reloc.asm.commons.Method;

public class ConstantMutationOperator
extends MutationOperator {
    private final Object constant;
    private final String id;

    public ConstantMutationOperator(String id, Object constant) {
        if (!TypeHelper.isConstantType(constant.getClass())) {
            throw new IllegalArgumentException();
        }
        this.constant = constant;
        this.id = id;
    }

    public Object getConstant() {
        return this.constant;
    }

    @Override
    public boolean canMutate(Method method) {
        Type methodType = method.getReturnType();
        int typeSort = methodType.getSort();
        Type constantType = Type.getType(this.constant.getClass());
        if (typeSort == 9 || typeSort == 11) {
            return false;
        }
        if (typeSort == 10) {
            return constantType.equals((Object)methodType);
        }
        return methodType.equals((Object)constantType) || methodType.equals((Object)Type.getType(TypeHelper.unwrap(this.constant.getClass())));
    }

    @Override
    public void generateCode(Method method, MethodVisitor mv) {
        assert (this.canMutate(method));
        mv.visitLdcInsn(this.constant);
        Type methodType = method.getReturnType();
        mv.visitLdcInsn(this.constant);
        mv.visitInsn(methodType.getOpcode(172));
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return "All method body replaced by: return " + this.id;
    }
}

