/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.stopmethods;

import java.util.Collection;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.sequence.Context;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;

@FunctionalInterface
public interface StopMethodMatcher {
    public boolean matches(ClassTree var1, MethodTree var2);

    public static boolean matchesNameDesc(MethodTree methodTree, String name, String desc) {
        MethodNode node = methodTree.rawNode();
        return node.name.equals(name) && node.desc.equals(desc);
    }

    public static boolean matchesAccess(MethodTree methodTree, int access) {
        return (methodTree.rawNode().access & access) != 0;
    }

    public static StopMethodMatcher forNameDesc(String name, String desc) {
        return (classTree, methodTree) -> StopMethodMatcher.matchesNameDesc(methodTree, name, desc);
    }

    public static StopMethodMatcher forAccess(int access) {
        return (classTree, methodTree) -> StopMethodMatcher.matchesAccess(methodTree, access);
    }

    public static StopMethodMatcher forBody(SequenceQuery<AbstractInsnNode> body) {
        SequenceMatcher matcher = body.compile(QueryParams.params().withIgnores(InstructionMatchers.isA(LabelNode.class).or(InstructionMatchers.isA(FrameNode.class)).or(InstructionMatchers.isA(LineNumberNode.class))));
        return (classTree, methodTree) -> {
            Context context;
            List instructions = methodTree.instructions();
            return matcher.matches(instructions, context = Context.start((List)methodTree.instructions())) && context.position() == instructions.size() - 1;
        };
    }

    public static StopMethodMatcher any(Collection<StopMethodMatcher> matchers) {
        return (classTree, methodTree) -> matchers.stream().anyMatch(matcher -> matcher.matches(classTree, methodTree));
    }
}

